/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CodecID;
import org.OpenNI.Context;
import org.OpenNI.GeneralException;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.RecordMedium;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class Recorder
extends ProductionNode {
    Recorder(Context context, long l, boolean bl) throws StatusException {
        super(context, l, bl);
    }

    public static Recorder create(Context context, String string) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateRecorder(context.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        Recorder recorder = (Recorder)context.createProductionNodeObject((Long)outArg.value, NodeType.RECORDER);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return recorder;
    }

    public String getFormat() {
        return NativeMethods.xnGetRecorderFormat(this.toNative());
    }

    public void setDestination(RecordMedium recordMedium, String string) throws StatusException {
        int n = NativeMethods.xnSetRecorderDestination(this.toNative(), recordMedium.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public RecordMedium getDestinationMedium() throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        OutArg<String> outArg2 = new OutArg<String>();
        int n = NativeMethods.xnGetRecorderDestination(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return RecordMedium.fromNative((Integer)outArg.value);
    }

    public String getDestination() throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        OutArg<String> outArg2 = new OutArg<String>();
        int n = NativeMethods.xnGetRecorderDestination(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return (String)outArg2.value;
    }

    public void addNodeToRecording(ProductionNode productionNode, CodecID codecID) throws StatusException {
        int n = NativeMethods.xnAddNodeToRecording(this.toNative(), productionNode.toNative(), codecID.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void addNodeToRecording(ProductionNode productionNode) throws StatusException {
        this.addNodeToRecording(productionNode, CodecID.Null);
    }

    public void removeNodeToRecording(ProductionNode productionNode) throws StatusException {
        int n = NativeMethods.xnRemoveNodeFromRecording(this.toNative(), productionNode.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void Record() throws StatusException {
        int n = NativeMethods.xnRecord(this.toNative());
        WrapperUtils.throwOnError(n);
    }
}

