/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.GeneralException;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeInfoList;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.PlayerSeekOrigin;
import org.OpenNI.ProductionNode;
import org.OpenNI.RecordMedium;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class Player
extends ProductionNode {
    private StateChangedObservable eofReached = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToEndOfFileReached(Player.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromEndOfFileReached(Player.this.toNative(), l);
        }
    };

    Player(Context context, long l, boolean bl) throws StatusException {
        super(context, l, bl);
    }

    public static Player create(Context context, String string) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreatePlayer(context.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        Player player = (Player)context.createProductionNodeObject((Long)outArg.value, NodeType.PLAYER);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return player;
    }

    public String getFormat() {
        return NativeMethods.xnGetPlayerSupportedFormat(this.toNative());
    }

    public void setSource(RecordMedium recordMedium, String string) throws StatusException {
        int n = NativeMethods.xnSetPlayerSource(this.toNative(), recordMedium.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public RecordMedium getSourceMedium() throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        OutArg<String> outArg2 = new OutArg<String>();
        int n = NativeMethods.xnGetPlayerSource(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return RecordMedium.fromNative((Integer)outArg.value);
    }

    public String getSource() throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        OutArg<String> outArg2 = new OutArg<String>();
        int n = NativeMethods.xnGetPlayerSource(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return (String)outArg2.value;
    }

    public void setRepeat(boolean bl) throws StatusException {
        int n = NativeMethods.xnSetPlayerRepeat(this.toNative(), bl);
        WrapperUtils.throwOnError(n);
    }

    public void readNext() throws StatusException {
        int n = NativeMethods.xnPlayerReadNext(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void seekToTimestamp(PlayerSeekOrigin playerSeekOrigin, long l) throws StatusException {
        int n = NativeMethods.xnSeekPlayerToTimeStamp(this.toNative(), l, playerSeekOrigin.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void seekToFrame(ProductionNode productionNode, PlayerSeekOrigin playerSeekOrigin, int n) throws StatusException {
        int n2 = NativeMethods.xnSeekPlayerToFrame(this.toNative(), productionNode.getName(), n, playerSeekOrigin.toNative());
        WrapperUtils.throwOnError(n2);
    }

    public long tellTimestamp() throws StatusException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnTellPlayerTimestamp(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (Long)outArg.value;
    }

    public int tellFrame(ProductionNode productionNode) throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        int n = NativeMethods.xnTellPlayerFrame(this.toNative(), productionNode.getName(), outArg);
        WrapperUtils.throwOnError(n);
        return (Integer)outArg.value;
    }

    public int getNumberOfFrames(ProductionNode productionNode) throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        int n = NativeMethods.xnGetPlayerNumFrames(this.toNative(), productionNode.getName(), outArg);
        WrapperUtils.throwOnError(n);
        return (Integer)outArg.value;
    }

    public NodeInfoList enumerateNodes() throws StatusException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnEnumeratePlayerNodes(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return new NodeInfoList((Long)outArg.value);
    }

    public boolean isEOF() {
        return NativeMethods.xnIsPlayerAtEOF(this.toNative());
    }

    public IStateChangedObservable getEOFReachedEvent() {
        return this.eofReached;
    }

    public double getPlaybackSpeed() {
        return NativeMethods.xnGetPlaybackSpeed(this.toNative());
    }

    public void setPlaybackSpeed(double d) throws StatusException {
        int n = NativeMethods.xnSetPlaybackSpeed(this.toNative(), d);
        WrapperUtils.throwOnError(n);
    }
}

