/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.IdEventArgs;
import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.PointFilter;
import com.primesense.NITE.SessionManager;
import org.OpenNI.BoundingBox3D;
import org.OpenNI.GeneralException;
import org.OpenNI.IObservable;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class PointArea
extends PointFilter {
    private Observable<IdEventArgs> pointSilencedEvent = new Observable<IdEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvPointArea_RegisterPointSilenced(PointArea.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvPointArea_UnregisterPointSilenced(PointArea.this.toNative(), l);
        }

        public void callback(int n) {
            this.notify((Object)new IdEventArgs(n));
        }
    };
    private Observable<IdEventArgs> pointRevivedEvent = new Observable<IdEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvPointArea_RegisterPointRevived(PointArea.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvPointArea_UnregisterPointRevived(PointArea.this.toNative(), l);
        }

        public void callback(int n) {
            this.notify((Object)new IdEventArgs(n));
        }
    };
    private Observable<IdEventArgs> silentPointRemovedEvent;

    public PointArea(BoundingBox3D boundingBox3D, boolean bl) throws GeneralException {
        this(boundingBox3D, bl, "");
    }

    public PointArea(BoundingBox3D boundingBox3D, boolean bl, String string) throws GeneralException {
        this(boundingBox3D.getMins(), boundingBox3D.getMaxs(), bl, string);
    }

    public PointArea(Point3D point3D, Point3D point3D2, boolean bl) throws GeneralException {
        this(point3D, point3D2, bl, "");
    }

    public PointArea(Point3D point3D, Point3D point3D2, boolean bl, String string) throws GeneralException {
        super(NativeMethods.xnvPointArea_Create(point3D.getX(), point3D.getY(), point3D.getZ(), point3D2.getX(), point3D2.getY(), point3D2.getZ(), bl, string));
        this.pointSilencedEvent = new Observable<IdEventArgs>(){

            protected int registerNative(OutArg<Long> outArg) {
                return NativeMethods.xnvPointArea_RegisterSilentPointRemoved(PointArea.this.toNative(), (Object)this, "callback", outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnvPointArea_UnregisterSilentPointRemoved(PointArea.this.toNative(), l);
            }

            public void callback(int n) {
                this.notify((Object)new IdEventArgs(n));
            }
        };
    }

    @Override
    protected void freeObject() {
        super.freeObject();
        NativeMethods.xnvPointArea_Destroy(this.toNative());
    }

    public void changeArea(BoundingBox3D boundingBox3D, boolean bl) throws StatusException {
        this.changeArea(boundingBox3D.getMins(), boundingBox3D.getMaxs(), bl);
    }

    public void changeArea(Point3D point3D, Point3D point3D2, boolean bl) throws StatusException {
        int n = NativeMethods.xnvPointArea_ChangeArea(this.toNative(), point3D.getX(), point3D.getY(), point3D.getZ(), point3D2.getX(), point3D2.getY(), point3D2.getZ(), bl);
        WrapperUtils.throwOnError((int)n);
    }

    public void RemoveSilentPoints(long l, SessionManager sessionManager) throws StatusException {
        int n = NativeMethods.xnvPointArea_RemoveSilent(this.toNative(), l, sessionManager.toNative());
        WrapperUtils.throwOnError((int)n);
    }

    public IObservable<IdEventArgs> getPointSilencedEvent() {
        return this.pointSilencedEvent;
    }

    public IObservable<IdEventArgs> getPointRevivedEvent() {
        return this.pointRevivedEvent;
    }

    public IObservable<IdEventArgs> getSilentPointRemovedEvent() {
        return this.silentPointRemovedEvent;
    }
}

