/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.PointFilter;
import org.OpenNI.GeneralException;
import org.OpenNI.OutArg;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class PointDenoiser
extends PointFilter {
    public PointDenoiser(float f, String string) throws GeneralException {
        super(NativeMethods.xnvPointDenoiser_Create(f, string));
    }

    public PointDenoiser(String string) throws GeneralException {
        this(10.0f, string);
    }

    public PointDenoiser(float f) throws GeneralException {
        this(f, "PointDenoiser");
    }

    public PointDenoiser() throws GeneralException {
        this(10.0f, "PointDenoiser");
    }

    @Override
    protected void freeObject() {
        super.freeObject();
        NativeMethods.xnvPointDenoiser_Destroy(this.toNative());
    }

    public void setDistanceThreshold(float f) throws StatusException {
        int n = NativeMethods.xnvPointDenoiser_SetDistanceThreshold(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public void setCloseRatio(float f) throws StatusException {
        int n = NativeMethods.xnvPointDenoiser_SetCloseRatio(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public void setFarRatio(float f) throws StatusException {
        int n = NativeMethods.xnvPointDenoiser_SetFarRatio(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getDistanceThreshold() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPointDenoiser_GetDistanceThreshold(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public float getCloseRatio() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPointDenoiser_GetCloseRatio(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public float getFarRatio() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPointDenoiser_GetFarRatio(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }
}

