/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE.Samples.Boxes;

import com.primesense.NITE.Axis;
import com.primesense.NITE.Direction;
import com.primesense.NITE.FlowRouter;
import com.primesense.NITE.HandPointEventArgs;
import com.primesense.NITE.IdEventArgs;
import com.primesense.NITE.IndexDirectionEventArgs;
import com.primesense.NITE.IndexEventArgs;
import com.primesense.NITE.MessageListener;
import com.primesense.NITE.PointEventArgs;
import com.primesense.NITE.Samples.Boxes.MyBox;
import com.primesense.NITE.SelectableSlider1D;
import com.primesense.NITE.SessionManager;
import com.primesense.NITE.ValueEventArgs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.OpenNI.Context;
import org.OpenNI.GeneralException;
import org.OpenNI.IObservable;
import org.OpenNI.IObserver;
import org.OpenNI.OutArg;
import org.OpenNI.ScriptNode;
import org.OpenNI.StatusException;

public class Boxes {
    JFrame frame;
    JPanel boxesPanel;
    JPanel panel1;
    JPanel panel2;
    JPanel panel3;
    JPanel sliderPanel;
    JPanel sliderCursor;
    private final String SAMPLE_XML_FILE = "../../../Data/Sample-Tracking.xml";
    private Context context;
    private OutArg<ScriptNode> scriptNode;
    private boolean shouldRun;
    private SessionManager sessionManager;
    private FlowRouter flowRouter;
    private SelectableSlider1D selectableSlider;
    private MyBox[] boxes;
    private Observer boxesObserver;

    public Boxes(JFrame jFrame) {
        this.frame = jFrame;
        this.boxesPanel = new JPanel();
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.panel3 = new JPanel();
        this.panel1.setPreferredSize(new Dimension(200, 75));
        this.panel2.setPreferredSize(new Dimension(200, 75));
        this.panel3.setPreferredSize(new Dimension(200, 75));
        this.sliderPanel = new JPanel();
        this.sliderPanel.setPreferredSize(new Dimension(600, 20));
        this.sliderPanel.setBackground(Color.GRAY);
        this.sliderCursor = new JPanel();
        this.sliderCursor.setBounds(300, 85, 6, 20);
        this.sliderCursor.setPreferredSize(new Dimension(6, 10));
        this.sliderCursor.setBackground(Color.ORANGE);
        this.boxesPanel.add((Component)this.panel1, "West");
        this.boxesPanel.add((Component)this.panel2, "Center");
        this.boxesPanel.add((Component)this.panel3, "East");
        jFrame.add(this.sliderCursor);
        jFrame.getContentPane().add((Component)this.sliderPanel, "South");
        jFrame.getContentPane().add(this.boxesPanel);
        jFrame.pack();
        jFrame.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    Boxes.this.shouldRun = false;
                }
            }
        });
        try {
            this.scriptNode = new OutArg();
            this.context = Context.createFromXmlFile((String)"../../../Data/Sample-Tracking.xml", this.scriptNode);
            this.sessionManager = new SessionManager(this.context, new String("Click"));
            this.flowRouter = new FlowRouter();
            this.selectableSlider = new SelectableSlider1D(3, Axis.X);
            this.boxes = new MyBox[3];
            this.boxes[0] = new MyBox("Box1", this.panel1);
            this.boxes[1] = new MyBox("Box2", this.panel2);
            this.boxes[2] = new MyBox("Box3", this.panel3);
            this.boxesObserver = new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    try {
                        Boxes.this.flowRouter.setActive((MessageListener)Boxes.this.selectableSlider);
                    }
                    catch (StatusException statusException) {
                        statusException.printStackTrace();
                    }
                }
            };
            this.boxes[0].getLeaveEvent().addObserver(this.boxesObserver);
            this.boxes[1].getLeaveEvent().addObserver(this.boxesObserver);
            this.boxes[2].getLeaveEvent().addObserver(this.boxesObserver);
            this.selectableSlider.getItemHoverEvent().addObserver((IObserver)new IObserver<IndexEventArgs>(){

                public void update(IObservable<IndexEventArgs> iObservable, IndexEventArgs indexEventArgs) {
                    Boxes.this.boxes[0].ChangeColor(Color.CYAN);
                    Boxes.this.boxes[1].ChangeColor(Color.CYAN);
                    Boxes.this.boxes[2].ChangeColor(Color.CYAN);
                    Boxes.this.boxes[indexEventArgs.getIndex()].ChangeColor(Color.YELLOW);
                }
            });
            this.selectableSlider.getItemSelectEvent().addObserver((IObserver)new IObserver<IndexDirectionEventArgs>(){

                public void update(IObservable<IndexDirectionEventArgs> iObservable, IndexDirectionEventArgs indexDirectionEventArgs) {
                    if (indexDirectionEventArgs.getDirection() == Direction.UP) {
                        try {
                            Boxes.this.flowRouter.setActive((MessageListener)Boxes.this.boxes[indexDirectionEventArgs.getIndex()]);
                        }
                        catch (StatusException statusException) {
                            statusException.printStackTrace();
                        }
                    }
                }
            });
            this.selectableSlider.getValueChangeEvent().addObserver((IObserver)new IObserver<ValueEventArgs>(){

                public void update(IObservable<ValueEventArgs> iObservable, ValueEventArgs valueEventArgs) {
                    Boxes.this.sliderCursor.setBounds((int)(valueEventArgs.getValue() * 600.0f), 85, 6, 20);
                }
            });
            this.selectableSlider.getPrimaryPointCreateEvent().addObserver((IObserver)new IObserver<HandPointEventArgs>(){

                public void update(IObservable<HandPointEventArgs> iObservable, HandPointEventArgs handPointEventArgs) {
                    Boxes.this.sliderPanel.setBackground(Color.RED);
                }
            });
            this.selectableSlider.getPrimaryPointDestroyEvent().addObserver((IObserver)new IObserver<IdEventArgs>(){

                public void update(IObservable<IdEventArgs> iObservable, IdEventArgs idEventArgs) {
                    Boxes.this.sliderPanel.setBackground(Color.WHITE);
                }
            });
            this.sessionManager.getSessionStartEvent().addObserver((IObserver)new IObserver<PointEventArgs>(){

                public void update(IObservable<PointEventArgs> iObservable, PointEventArgs pointEventArgs) {
                    System.out.println("Session Start");
                    try {
                        Boxes.this.flowRouter.setActive((MessageListener)Boxes.this.selectableSlider);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            this.sessionManager.addListener((MessageListener)this.flowRouter);
            this.shouldRun = true;
        }
        catch (GeneralException generalException) {
            generalException.printStackTrace();
        }
    }

    void run() {
        while (this.shouldRun) {
            try {
                this.context.waitAnyUpdateAll();
                this.sessionManager.update(this.context);
            }
            catch (StatusException statusException) {
                statusException.printStackTrace();
                break;
            }
        }
        this.frame.dispose();
    }
}

