/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.SessionGenerator;
import org.OpenNI.BoundingBox3D;
import org.OpenNI.Context;
import org.OpenNI.GeneralException;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class SessionManager
extends SessionGenerator {
    public SessionManager(Context context, String string, String string2) throws GeneralException {
        super(NativeMethods.xnvSessionManager_Create("SessionManager"));
        int n = NativeMethods.xnvSessionManager_Initialize(this.toNative(), context.toNative(), string, string2);
        WrapperUtils.throwOnError((int)n);
    }

    public SessionManager(Context context, String string) throws GeneralException {
        this(context, string, "");
    }

    @Override
    protected void freeObject() {
        super.freeObject();
        NativeMethods.xnvSessionManager_Destroy(this.toNative());
    }

    public void update(Context context) throws StatusException {
        int n = NativeMethods.xnvSessionManager_Update(this.toNative(), context.toNative());
        WrapperUtils.throwOnError((int)n);
    }

    public void setQuickRefocusTimeout(int n) throws StatusException {
        int n2 = NativeMethods.xnvSessionManager_SetQuickRefocusTimeout(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public int getQuickRefocusTimeout() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSessionManager_GetQuickRefocusTimeout(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public void setQuickRefocusArea(BoundingBox3D boundingBox3D) throws StatusException {
        int n = NativeMethods.xnvSessionManager_SetQuickRefocusArea(this.toNative(), boundingBox3D.getMins().getX(), boundingBox3D.getMins().getY(), boundingBox3D.getMins().getZ(), boundingBox3D.getMaxs().getX(), boundingBox3D.getMaxs().getY(), boundingBox3D.getMaxs().getZ());
        WrapperUtils.throwOnError((int)n);
    }

    public void setQuickRefocusArea(Point3D point3D) throws StatusException {
        this.setQuickRefocusArea(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public void setQuickRefocusArea(float f, float f2, float f3) throws StatusException {
        int n = NativeMethods.xnvSessionManager_SetQuickRefocusAreaByLength(this.toNative(), f, f2, f3);
        WrapperUtils.throwOnError((int)n);
    }

    public Point3D getQuickRefocusArea() throws StatusException {
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        OutArg outArg3 = new OutArg();
        int n = NativeMethods.xnvSessionManager_GetQuickRefocusArea(this.toNative(), (OutArg<Float>)outArg, (OutArg<Float>)outArg2, (OutArg<Float>)outArg3);
        WrapperUtils.throwOnError((int)n);
        return new Point3D(((Float)outArg.value).floatValue(), ((Float)outArg2.value).floatValue(), ((Float)outArg3.value).floatValue());
    }

    public void ForceQuickRefocus(BoundingBox3D boundingBox3D, int n) throws StatusException {
        int n2 = NativeMethods.xnvSessionManager_ForceQuickRefocus(this.toNative(), boundingBox3D.getMins().getX(), boundingBox3D.getMins().getY(), boundingBox3D.getMins().getZ(), boundingBox3D.getMaxs().getX(), boundingBox3D.getMaxs().getY(), boundingBox3D.getMaxs().getZ(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public int addGestureByContext(Context context, String string) throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSessionManager_AddGestureByContext(this.toNative(), context.toNative(), string, (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public int addQuickRefocusByContext(Context context, String string) throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSessionManager_AddQuickRefocusByContext(this.toNative(), context.toNative(), string, (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public void removeGesture(int n) throws StatusException {
        int n2 = NativeMethods.xnvSessionManager_RemoveGesture(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public void removeQuickRefocus(int n) throws StatusException {
        int n2 = NativeMethods.xnvSessionManager_RemoveQuickRefocus(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public void startPrimaryStatic() throws StatusException {
        int n = NativeMethods.xnvSessionManager_StartPrimaryStatic(this.toNative());
        WrapperUtils.throwOnError((int)n);
    }

    public void stopPrimaryStatic() throws StatusException {
        int n = NativeMethods.xnvSessionManager_StopPrimaryStatic(this.toNative());
        WrapperUtils.throwOnError((int)n);
    }

    public void setPrimaryStaticTimeout(float f) throws StatusException {
        int n = NativeMethods.xnvSessionManager_SetPrimaryStaticTimeout(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getPrimaryStaticTimeout() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSessionManager_GetPrimaryStaticTimeout(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setPrimaryStaticBox(Point3D point3D) throws StatusException {
        this.setPrimaryStaticBox(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public void setPrimaryStaticBox(float f, float f2, float f3) throws StatusException {
        int n = NativeMethods.xnvSessionManager_SetPrimaryStaticBoundingBox(this.toNative(), f, f2, f3);
        WrapperUtils.throwOnError((int)n);
    }

    public Point3D getPrimaryStaticBox() throws StatusException {
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        OutArg outArg3 = new OutArg();
        int n = NativeMethods.xnvSessionManager_GetPrimaryStaticBoundingBox(this.toNative(), (OutArg<Float>)outArg, (OutArg<Float>)outArg2, (OutArg<Float>)outArg3);
        WrapperUtils.throwOnError((int)n);
        return new Point3D(((Float)outArg.value).floatValue(), ((Float)outArg2.value).floatValue(), ((Float)outArg3.value).floatValue());
    }
}

