/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.AudioMetaData;
import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.Generator;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.Query;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WaveOutputMode;
import org.OpenNI.WrapperUtils;

public class AudioGenerator
extends Generator {
    private StateChangedObservable waveOutputModeChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToWaveOutputModeChanges(AudioGenerator.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromWaveOutputModeChanges(AudioGenerator.this.toNative(), l);
        }
    };

    public AudioGenerator(Context context, long l, boolean bl) throws GeneralException {
        super(context, l, bl);
    }

    public static AudioGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateAudioGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        AudioGenerator audioGenerator = (AudioGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.AUDIO);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return audioGenerator;
    }

    public static AudioGenerator create(Context context, Query query) throws GeneralException {
        return AudioGenerator.create(context, query, null);
    }

    public static AudioGenerator create(Context context) throws GeneralException {
        return AudioGenerator.create(context, null, null);
    }

    public WaveOutputMode[] getSupportedMapOutputModes() throws StatusException {
        int n = NativeMethods.xnGetSupportedWaveOutputModesCount(this.toNative());
        WaveOutputMode[] waveOutputModeArray = new WaveOutputMode[n];
        int n2 = NativeMethods.xnGetSupportedWaveOutputModes(this.toNative(), waveOutputModeArray);
        WrapperUtils.throwOnError(n2);
        return waveOutputModeArray;
    }

    public WaveOutputMode getWaveOutputMode() throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        OutArg<Short> outArg2 = new OutArg<Short>();
        OutArg<Byte> outArg3 = new OutArg<Byte>();
        int n = NativeMethods.xnGetWaveOutputMode(this.toNative(), outArg, outArg2, outArg3);
        WrapperUtils.throwOnError(n);
        return new WaveOutputMode((Integer)outArg.value, (Short)outArg2.value, (Byte)outArg3.value);
    }

    public void setWaveOutputMode(WaveOutputMode waveOutputMode) throws StatusException {
        int n = NativeMethods.xnSetWaveOutputMode(this.toNative(), waveOutputMode.getSampleRate(), waveOutputMode.getBitsPerSample(), waveOutputMode.getNumberOfChannels());
        WrapperUtils.throwOnError(n);
    }

    public IStateChangedObservable getMapOutputModeChangedEvent() {
        return this.waveOutputModeChanged;
    }

    public void getMetaData(AudioMetaData audioMetaData) {
        NativeMethods.xnGetAudioMetaData(this.toNative(), audioMetaData);
    }

    public AudioMetaData getMetaData() {
        AudioMetaData audioMetaData = new AudioMetaData();
        this.getMetaData(audioMetaData);
        return audioMetaData;
    }
}

