/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.openni.DeviceInfo;
import org.openni.NativeMethods;
import org.openni.OutArg;
import org.openni.Version;
import org.openni.VideoStream;

public class OpenNI {
    public static final int TIMEOUT_FOREVER = -1;
    private static List<DeviceConnectedListener> mDeviceConnectedListener;
    private static List<DeviceDisconnectedListener> mDeviceDisconnectedListener;
    private static List<DeviceStateChangedListener> mDeviceStateChangedListener;

    public static void initialize() {
        NativeMethods.checkReturnStatus(NativeMethods.oniInitialize());
        mDeviceConnectedListener = new ArrayList<DeviceConnectedListener>();
        mDeviceDisconnectedListener = new ArrayList<DeviceDisconnectedListener>();
        mDeviceStateChangedListener = new ArrayList<DeviceStateChangedListener>();
    }

    public static void shutdown() {
        NativeMethods.oniShutdown();
    }

    public static Version getVersion() {
        return NativeMethods.oniGetVersion();
    }

    public static String getExtendedError() {
        return NativeMethods.oniGetExtendedError();
    }

    public static List<DeviceInfo> enumerateDevices() {
        ArrayList<DeviceInfo> arrayList = new ArrayList<DeviceInfo>();
        NativeMethods.checkReturnStatus(NativeMethods.oniGetDeviceList(arrayList));
        return arrayList;
    }

    public static int waitForAnyStream(List<VideoStream> list, int n) throws TimeoutException {
        long[] lArray = new long[list.size()];
        OutArg<Integer> outArg = new OutArg<Integer>();
        Iterator<VideoStream> iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            lArray[n2] = iterator.next().getHandle();
            ++n2;
        }
        boolean bl = NativeMethods.oniWaitForAnyStream(lArray, outArg, n);
        if (bl) {
            return (Integer)outArg.mValue;
        }
        throw new TimeoutException();
    }

    public static void addDeviceConnectedListener(DeviceConnectedListener deviceConnectedListener) {
        mDeviceConnectedListener.add(deviceConnectedListener);
    }

    public static void removeDeviceConnectedListener(DeviceConnectedListener deviceConnectedListener) {
        mDeviceConnectedListener.remove(deviceConnectedListener);
    }

    public static void addDeviceDisconnectedListener(DeviceDisconnectedListener deviceDisconnectedListener) {
        mDeviceDisconnectedListener.add(deviceDisconnectedListener);
    }

    public static void removeDeviceDisconnectedListener(DeviceDisconnectedListener deviceDisconnectedListener) {
        mDeviceDisconnectedListener.remove(deviceDisconnectedListener);
    }

    public static void addDeviceStateChangedListener(DeviceStateChangedListener deviceStateChangedListener) {
        mDeviceStateChangedListener.add(deviceStateChangedListener);
    }

    public static void removeDeviceStateChangedListener(DeviceStateChangedListener deviceStateChangedListener) {
        mDeviceStateChangedListener.remove(deviceStateChangedListener);
    }

    private static void deviceConnected(DeviceInfo deviceInfo) {
        for (DeviceConnectedListener deviceConnectedListener : mDeviceConnectedListener) {
            deviceConnectedListener.onDeviceConnected(deviceInfo);
        }
    }

    private static void deviceDisconnected(DeviceInfo deviceInfo) {
        for (DeviceDisconnectedListener deviceDisconnectedListener : mDeviceDisconnectedListener) {
            deviceDisconnectedListener.onDeviceDisconnected(deviceInfo);
        }
    }

    private static void deviceStateChanged(DeviceInfo deviceInfo, int n) {
        for (DeviceStateChangedListener deviceStateChangedListener : mDeviceStateChangedListener) {
            deviceStateChangedListener.onDeviceStateChanged(deviceInfo, n);
        }
    }

    public static interface DeviceStateChangedListener {
        public void onDeviceStateChanged(DeviceInfo var1, int var2);
    }

    public static interface DeviceDisconnectedListener {
        public void onDeviceDisconnected(DeviceInfo var1);
    }

    public static interface DeviceConnectedListener {
        public void onDeviceConnected(DeviceInfo var1);
    }
}

