/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import java.nio.ByteBuffer;
import org.openni.NativeMethods;
import org.openni.SensorType;
import org.openni.VideoMode;

public class VideoFrameRef {
    private long mFrameHandle;
    private long mTimestamp;
    private VideoMode mVideoMode;
    private ByteBuffer mData;
    private SensorType mSensorType;
    private int mIndex;
    private int mWidth;
    private int mHeight;
    private int mCropOrigX;
    private int mCropOrigY;
    private int mStride;
    private boolean mIsCropping;

    public final ByteBuffer getData() {
        return this.mData;
    }

    public SensorType getSensorType() {
        return this.mSensorType;
    }

    public final VideoMode getVideoMode() {
        return this.mVideoMode;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public int getFrameIndex() {
        return this.mIndex;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public boolean getCroppingEnabled() {
        return this.mIsCropping;
    }

    public int getCropOriginX() {
        return this.mCropOrigX;
    }

    public int getCropOriginY() {
        return this.mCropOrigY;
    }

    public int getStrideInBytes() {
        return this.mStride;
    }

    public void release() {
        if (this.mFrameHandle != 0L) {
            NativeMethods.oniFrameRelease(this.mFrameHandle);
            this.mFrameHandle = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    private VideoFrameRef(long l) {
        NativeMethods.oniFrameAddRef(l);
        this.mFrameHandle = l;
    }
}

