/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import java.util.HashMap;
import java.util.Map;
import org.openni.CropArea;
import org.openni.Device;
import org.openni.NativeMethods;
import org.openni.OutArg;
import org.openni.SensorInfo;
import org.openni.SensorType;
import org.openni.VideoFrameRef;
import org.openni.VideoMode;

public class VideoStream {
    private final SensorType mSensorType;
    private static HashMap<VideoStream, NewFrameListener> mFrameListeners;
    private long mStreamHandle;
    private long mCallbackHandle;

    public static VideoStream create(Device device, SensorType sensorType) {
        VideoStream videoStream = new VideoStream(sensorType);
        if (mFrameListeners == null) {
            mFrameListeners = new HashMap();
        }
        NativeMethods.checkReturnStatus(NativeMethods.oniDeviceCreateStream(device.getHandle(), sensorType.toNative(), videoStream));
        return videoStream;
    }

    public void destroy() {
        NativeMethods.oniStreamDestroy(this.getHandle(), this.mCallbackHandle);
        this.mStreamHandle = 0L;
    }

    public final SensorInfo getSensorInfo() {
        return NativeMethods.oniStreamGetSensorInfo(this.getHandle());
    }

    public void start() {
        NativeMethods.checkReturnStatus(NativeMethods.oniStreamStart(this.getHandle()));
    }

    public void stop() {
        NativeMethods.oniStreamStop(this.getHandle());
    }

    public VideoFrameRef readFrame() {
        OutArg<VideoFrameRef> outArg = new OutArg<VideoFrameRef>();
        NativeMethods.checkReturnStatus(NativeMethods.oniStreamReadFrame(this.getHandle(), outArg));
        return (VideoFrameRef)outArg.mValue;
    }

    public void addNewFrameListener(NewFrameListener newFrameListener) {
        mFrameListeners.put(this, newFrameListener);
    }

    public void removeNewFrameListener(NewFrameListener newFrameListener) {
        for (Map.Entry<VideoStream, NewFrameListener> entry : mFrameListeners.entrySet()) {
            VideoStream videoStream = entry.getKey();
            if (videoStream.getHandle() != this.mStreamHandle || !newFrameListener.equals(entry.getValue())) continue;
            mFrameListeners.remove(entry.getKey());
            return;
        }
    }

    public long getHandle() {
        return this.mStreamHandle;
    }

    public CameraSettings getCameraSettings() {
        if (NativeMethods.oniStreamIsPropertySupported(this.getHandle(), 100) && NativeMethods.oniStreamIsPropertySupported(this.getHandle(), 101)) {
            return new CameraSettings(this);
        }
        return null;
    }

    public final VideoMode getVideoMode() {
        OutArg<VideoMode> outArg = new OutArg<VideoMode>();
        NativeMethods.checkReturnStatus(NativeMethods.getVideoMode(this.getHandle(), outArg));
        return (VideoMode)outArg.mValue;
    }

    public void setVideoMode(VideoMode videoMode) {
        NativeMethods.checkReturnStatus(NativeMethods.setVideoMode(this.getHandle(), videoMode.getResolutionX(), videoMode.getResolutionY(), videoMode.getFps(), videoMode.getPixelFormat().toNative()));
    }

    public int getMaxPixelValue() {
        OutArg<Integer> outArg = new OutArg<Integer>();
        NativeMethods.oniStreamGetIntProperty(this.getHandle(), 4, outArg);
        return (Integer)outArg.mValue;
    }

    public int getMinPixelValue() {
        OutArg<Integer> outArg = new OutArg<Integer>();
        NativeMethods.checkReturnStatus(NativeMethods.oniStreamGetIntProperty(this.getHandle(), 5, outArg));
        return (Integer)outArg.mValue;
    }

    public boolean isCroppingSupported() {
        return NativeMethods.oniStreamIsPropertySupported(this.getHandle(), 0);
    }

    public CropArea getCropping() {
        OutArg<Integer> outArg = new OutArg<Integer>();
        OutArg<Integer> outArg2 = new OutArg<Integer>();
        OutArg<Integer> outArg3 = new OutArg<Integer>();
        OutArg<Integer> outArg4 = new OutArg<Integer>();
        NativeMethods.checkReturnStatus(NativeMethods.getCropping(this.getHandle(), outArg, outArg2, outArg3, outArg4));
        return new CropArea((Integer)outArg.mValue, (Integer)outArg2.mValue, (Integer)outArg3.mValue, (Integer)outArg4.mValue);
    }

    public void setCropping(CropArea cropArea) {
        NativeMethods.checkReturnStatus(NativeMethods.setCropping(this.getHandle(), cropArea.getOriginX(), cropArea.getOriginY(), cropArea.getWidth(), cropArea.getHeight()));
    }

    public void resetCropping() {
        NativeMethods.checkReturnStatus(NativeMethods.resetCropping(this.getHandle()));
    }

    public boolean getMirroringEnabled() {
        OutArg<Boolean> outArg = new OutArg<Boolean>();
        NativeMethods.checkReturnStatus(NativeMethods.oniStreamGetBoolProperty(this.getHandle(), 7, outArg));
        return (Boolean)outArg.mValue;
    }

    public void setMirroringEnabled(boolean bl) {
        NativeMethods.checkReturnStatus(NativeMethods.oniStreamSetProperty(this.getHandle(), 7, bl));
    }

    public float getHorizontalFieldOfView() {
        OutArg<Float> outArg = new OutArg<Float>();
        NativeMethods.checkReturnStatus(NativeMethods.oniStreamGetFloatProperty(this.getHandle(), 1, outArg));
        return ((Float)outArg.mValue).floatValue();
    }

    public float getVerticalFieldOfView() {
        OutArg<Float> outArg = new OutArg<Float>();
        NativeMethods.checkReturnStatus(NativeMethods.oniStreamGetFloatProperty(this.getHandle(), 2, outArg));
        return ((Float)outArg.mValue).floatValue();
    }

    public SensorType getSensorType() {
        return this.mSensorType;
    }

    private VideoStream(SensorType sensorType) {
        this.mSensorType = sensorType;
    }

    private static void onFrameReady(long l) {
        for (Map.Entry<VideoStream, NewFrameListener> entry : mFrameListeners.entrySet()) {
            VideoStream videoStream = entry.getKey();
            if (videoStream.getHandle() != l) continue;
            entry.getValue().onFrameReady(videoStream);
        }
    }

    public static interface NewFrameListener {
        public void onFrameReady(VideoStream var1);
    }

    public class CameraSettings {
        private final VideoStream mVideoStream;

        public void setAutoExposureEnabled(boolean bl) {
            NativeMethods.checkReturnStatus(NativeMethods.oniStreamSetProperty(this.mVideoStream.getHandle(), 100, bl));
        }

        public void setAutoWhiteBalanceEnabled(boolean bl) {
            NativeMethods.checkReturnStatus(NativeMethods.oniStreamSetProperty(this.mVideoStream.getHandle(), 101, bl));
        }

        public boolean getAutoExposureEnabled() {
            OutArg<Boolean> outArg = new OutArg<Boolean>();
            NativeMethods.oniStreamGetBoolProperty(this.mVideoStream.getHandle(), 100, outArg);
            return (Boolean)outArg.mValue;
        }

        public boolean getAutoWhiteBalanceEnabled() {
            OutArg<Boolean> outArg = new OutArg<Boolean>();
            NativeMethods.oniStreamGetBoolProperty(this.mVideoStream.getHandle(), 101, outArg);
            return (Boolean)outArg.mValue;
        }

        private CameraSettings(VideoStream videoStream2) {
            this.mVideoStream = videoStream2;
        }
    }
}

