/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.nite.Samples.HandViewer;

import com.primesense.nite.GestureData;
import com.primesense.nite.HandData;
import com.primesense.nite.HandTracker;
import com.primesense.nite.HandTrackerFrameRef;
import com.primesense.nite.Point2D;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.openni.VideoFrameRef;

public class HandViewer
extends Component
implements HandTracker.NewFrameListener {
    float[] mHistogram;
    int[] mDepthPixels;
    HandTracker mTracker;
    HandTrackerFrameRef mLastFrame;
    BufferedImage mBufferedImage;

    public HandViewer(HandTracker handTracker) {
        this.mTracker = handTracker;
        this.mTracker.addNewFrameListener(this);
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        if (this.mLastFrame == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        VideoFrameRef videoFrameRef = this.mLastFrame.getDepthFrame();
        if (videoFrameRef != null) {
            int n3 = videoFrameRef.getWidth();
            int n4 = videoFrameRef.getHeight();
            if (this.mBufferedImage == null || this.mBufferedImage.getWidth() != n3 || this.mBufferedImage.getHeight() != n4) {
                this.mBufferedImage = new BufferedImage(n3, n4, 1);
            }
            this.mBufferedImage.setRGB(0, 0, n3, n4, this.mDepthPixels, 0, n3);
            n = (this.getWidth() - n3) / 2;
            n2 = (this.getHeight() - n4) / 2;
            graphics.drawImage(this.mBufferedImage, n, n2, null);
        }
        for (HandData handData : this.mLastFrame.getHands()) {
            if (!handData.isTracking()) continue;
            Point2D<Float> point2D = this.mTracker.convertHandCoordinatesToDepth(handData.getPosition());
            graphics.drawRect(n + point2D.getX().intValue() - 3, n2 + point2D.getY().intValue() - 3, 5, 5);
        }
    }

    @Override
    public synchronized void onNewFrame(HandTracker handTracker) {
        if (this.mLastFrame != null) {
            this.mLastFrame.release();
            this.mLastFrame = null;
        }
        this.mLastFrame = this.mTracker.readFrame();
        for (GestureData object : this.mLastFrame.getGestures()) {
            if (!object.isComplete()) continue;
            this.mTracker.startHandTracking(object.getCurrentPosition());
        }
        VideoFrameRef videoFrameRef = this.mLastFrame.getDepthFrame();
        if (videoFrameRef != null) {
            ByteBuffer byteBuffer = videoFrameRef.getData().order(ByteOrder.LITTLE_ENDIAN);
            if (this.mDepthPixels == null || this.mDepthPixels.length < videoFrameRef.getWidth() * videoFrameRef.getHeight()) {
                this.mDepthPixels = new int[videoFrameRef.getWidth() * videoFrameRef.getHeight()];
            }
            this.calcHist(byteBuffer);
            byteBuffer.rewind();
            int n = 0;
            while (byteBuffer.remaining() > 0) {
                short s = byteBuffer.getShort();
                short s2 = (short)this.mHistogram[s];
                this.mDepthPixels[n] = 0xFF000000 | s2 << 16 | s2 << 8;
                ++n;
            }
        }
        this.repaint();
    }

    private void calcHist(ByteBuffer byteBuffer) {
        int n;
        int n2;
        if (this.mHistogram == null) {
            this.mHistogram = new float[10000];
        }
        for (n2 = 0; n2 < this.mHistogram.length; ++n2) {
            this.mHistogram[n2] = 0.0f;
        }
        n2 = 0;
        while (byteBuffer.remaining() > 0) {
            n = byteBuffer.getShort() & 0xFFFF;
            if (n > 9999) {
                System.out.println("here: " + n);
            }
            if (n == 0) continue;
            int n3 = n;
            this.mHistogram[n3] = this.mHistogram[n3] + 1.0f;
            ++n2;
        }
        for (n = 1; n < this.mHistogram.length; ++n) {
            int n4 = n;
            this.mHistogram[n4] = this.mHistogram[n4] + this.mHistogram[n - 1];
        }
        if (n2 > 0) {
            for (n = 1; n < this.mHistogram.length; ++n) {
                this.mHistogram[n] = (int)(256.0f * (1.0f - this.mHistogram[n] / (float)n2));
            }
        }
    }
}

