/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.nite.Samples.HandViewer;

import com.primesense.nite.GestureType;
import com.primesense.nite.HandTracker;
import com.primesense.nite.NiTE;
import com.primesense.nite.Samples.HandViewer.HandViewer;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openni.Device;
import org.openni.DeviceInfo;
import org.openni.OpenNI;

public class HandViewerApplication {
    private JFrame mFrame = new JFrame("NiTE Hand Tracker Viewer");
    private HandViewer mViewer;
    private boolean mShouldRun = true;

    public HandViewerApplication(HandTracker handTracker) {
        this.mViewer = new HandViewer(handTracker);
        this.mFrame.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    HandViewerApplication.this.mShouldRun = false;
                }
            }
        });
        this.mFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HandViewerApplication.this.mShouldRun = false;
            }
        });
        this.mViewer.setSize(800, 600);
        this.mFrame.add("Center", this.mViewer);
        this.mFrame.setSize(this.mViewer.getWidth(), this.mViewer.getHeight());
        this.mFrame.setVisible(true);
    }

    void run() {
        while (this.mShouldRun) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.mFrame.dispose();
    }

    public static void main(String[] stringArray) {
        OpenNI.initialize();
        NiTE.initialize();
        List<DeviceInfo> list = OpenNI.enumerateDevices();
        if (list.size() == 0) {
            JOptionPane.showMessageDialog(null, "No device is connected", "Error", 0);
            return;
        }
        Device device = Device.open(list.get(0).getUri());
        HandTracker handTracker = HandTracker.create();
        handTracker.startGestureDetection(GestureType.CLICK);
        handTracker.startGestureDetection(GestureType.WAVE);
        HandViewerApplication handViewerApplication = new HandViewerApplication(handTracker);
        handViewerApplication.run();
    }
}

