/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.nite;

import com.primesense.nite.GestureType;
import com.primesense.nite.HandTrackerFrameRef;
import com.primesense.nite.NativeMethods;
import com.primesense.nite.OutArg;
import com.primesense.nite.Point2D;
import com.primesense.nite.Point3D;
import java.util.HashMap;
import java.util.Map;
import org.openni.Device;

public class HandTracker {
    private long mHandTrackerHandle;
    private long mCookieHandle;
    private static Map<HandTracker, NewFrameListener> mNewFramesListeners;

    public static HandTracker create(Device device) {
        HandTracker handTracker = new HandTracker();
        NativeMethods.checkReturnStatus(NativeMethods.niteInitializeHandTrackerByDevice(device.getHandle(), handTracker));
        return handTracker;
    }

    public static HandTracker create() {
        HandTracker handTracker = new HandTracker();
        NativeMethods.checkReturnStatus(NativeMethods.niteInitializeHandTracker(handTracker));
        return handTracker;
    }

    public void destroy() {
        NativeMethods.checkReturnStatus(NativeMethods.niteShutdownHandTracker(this.mHandTrackerHandle, this.mCookieHandle));
    }

    public long getHandle() {
        return this.mHandTrackerHandle;
    }

    public HandTrackerFrameRef readFrame() {
        OutArg<HandTrackerFrameRef> outArg = new OutArg<HandTrackerFrameRef>();
        NativeMethods.checkReturnStatus(NativeMethods.niteReadHandTrackerFrame(this.mHandTrackerHandle, outArg));
        return (HandTrackerFrameRef)outArg.mValue;
    }

    public void setSmoothingFactor(float f) {
        NativeMethods.checkReturnStatus(NativeMethods.niteSetHandSmoothingFactor(this.mHandTrackerHandle, f));
    }

    public float getSmoothingFactor() {
        OutArg<Float> outArg = new OutArg<Float>();
        NativeMethods.checkReturnStatus(NativeMethods.niteGetHandSmoothingFactor(this.mHandTrackerHandle, outArg));
        return ((Float)outArg.mValue).floatValue();
    }

    public short startHandTracking(Point3D<Float> point3D) {
        OutArg<Short> outArg = new OutArg<Short>();
        NativeMethods.checkReturnStatus(NativeMethods.niteStartHandTracking(this.mHandTrackerHandle, point3D.getX().floatValue(), point3D.getY().floatValue(), point3D.getZ().floatValue(), outArg));
        return (Short)outArg.mValue;
    }

    public void stopHandTracking(short s) {
        NativeMethods.niteStopHandTracking(this.mHandTrackerHandle, s);
    }

    public void addNewFrameListener(NewFrameListener newFrameListener) {
        mNewFramesListeners.put(this, newFrameListener);
    }

    public void removeNewFrameListener(NewFrameListener newFrameListener) {
        for (Map.Entry<HandTracker, NewFrameListener> entry : mNewFramesListeners.entrySet()) {
            HandTracker handTracker = entry.getKey();
            if (handTracker.getHandle() != this.mHandTrackerHandle || !newFrameListener.equals(entry.getValue())) continue;
            mNewFramesListeners.remove(entry.getKey());
            return;
        }
    }

    public void startGestureDetection(GestureType gestureType) {
        NativeMethods.checkReturnStatus(NativeMethods.niteStartGestureDetection(this.mHandTrackerHandle, gestureType.toNative()));
    }

    public void stopGestureDetection(GestureType gestureType) {
        NativeMethods.niteStopGestureDetection(this.mHandTrackerHandle, gestureType.toNative());
    }

    public Point2D<Float> convertHandCoordinatesToDepth(Point3D<Float> point3D) {
        OutArg<Float> outArg = new OutArg<Float>();
        OutArg<Float> outArg2 = new OutArg<Float>();
        NativeMethods.checkReturnStatus(NativeMethods.niteConvertHandCoordinatesToDepth(this.getHandle(), point3D.getX().floatValue(), point3D.getY().floatValue(), point3D.getZ().floatValue(), outArg, outArg2));
        return new Point2D<Float>((Float)outArg.mValue, (Float)outArg2.mValue);
    }

    public Point2D<Float> convertDepthCoordinatesToHand(Point3D<Integer> point3D) {
        OutArg<Float> outArg = new OutArg<Float>();
        OutArg<Float> outArg2 = new OutArg<Float>();
        NativeMethods.checkReturnStatus(NativeMethods.niteConvertDepthCoordinatesToHand(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ(), outArg, outArg2));
        return new Point2D<Float>((Float)outArg.mValue, (Float)outArg2.mValue);
    }

    private HandTracker() {
        mNewFramesListeners = new HashMap<HandTracker, NewFrameListener>();
    }

    private static void onFrameReady(long l) {
        for (Map.Entry<HandTracker, NewFrameListener> entry : mNewFramesListeners.entrySet()) {
            HandTracker handTracker = entry.getKey();
            if (handTracker.getHandle() != l) continue;
            entry.getValue().onNewFrame(handTracker);
        }
    }

    public static interface NewFrameListener {
        public void onNewFrame(HandTracker var1);
    }
}

