/*
 * Decompiled with CFR 0.152.
 */
package org.openni.Samples.SimpleRead;

import org.openni.Context;
import org.openni.DepthGenerator;
import org.openni.DepthMetaData;
import org.openni.ErrorStateEventArgs;
import org.openni.IObservable;
import org.openni.IObserver;
import org.openni.NodeType;
import org.openni.OutArg;

public class SimpleRead
implements IObserver<ErrorStateEventArgs> {
    public static final String SAMPLES_XML = "../../Config/SamplesConfig.xml";

    public static void main(String[] stringArray) {
        try {
            OutArg outArg = new OutArg();
            Context context = Context.createFromXmlFile((String)SAMPLES_XML, (OutArg)outArg);
            SimpleRead simpleRead = new SimpleRead();
            context.getErrorStateChangedEvent().addObserver((IObserver)simpleRead);
            DepthGenerator depthGenerator = (DepthGenerator)context.findExistingNode(NodeType.DEPTH);
            DepthMetaData depthMetaData = new DepthMetaData();
            while (true) {
                context.waitAnyUpdateAll();
                depthGenerator.getMetaData(depthMetaData);
                System.out.printf("Frame %d Middle point is: %d.\n", depthMetaData.getFrameID(), depthMetaData.getData().readPixel(depthMetaData.getXRes() / 2, depthMetaData.getYRes() / 2));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void update(IObservable<ErrorStateEventArgs> iObservable, ErrorStateEventArgs errorStateEventArgs) {
        System.out.printf("Global error state has changed: %s", errorStateEventArgs.getCurrentError());
        System.exit(1);
    }
}

