/*
 * Decompiled with CFR 0.152.
 */
package org.openni.Samples.UserTracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ShortBuffer;
import java.util.HashMap;
import org.openni.CalibrationProgressEventArgs;
import org.openni.CalibrationProgressStatus;
import org.openni.Context;
import org.openni.DepthGenerator;
import org.openni.DepthMetaData;
import org.openni.GeneralException;
import org.openni.IObservable;
import org.openni.IObserver;
import org.openni.OutArg;
import org.openni.Point3D;
import org.openni.PoseDetectionCapability;
import org.openni.PoseDetectionEventArgs;
import org.openni.SceneMetaData;
import org.openni.ScriptNode;
import org.openni.SkeletonCapability;
import org.openni.SkeletonJoint;
import org.openni.SkeletonJointPosition;
import org.openni.SkeletonProfile;
import org.openni.StatusException;
import org.openni.UserEventArgs;
import org.openni.UserGenerator;

public class UserTracker
extends Component {
    private static final long serialVersionUID = 1L;
    private OutArg<ScriptNode> scriptNode;
    private Context context;
    private DepthGenerator depthGen;
    private UserGenerator userGen;
    private SkeletonCapability skeletonCap;
    private PoseDetectionCapability poseDetectionCap;
    private byte[] imgbytes;
    private float[] histogram;
    String calibPose = null;
    HashMap<Integer, HashMap<SkeletonJoint, SkeletonJointPosition>> joints;
    private boolean drawBackground = true;
    private boolean drawPixels = true;
    private boolean drawSkeleton = true;
    private boolean printID = true;
    private boolean printState = true;
    private BufferedImage bimg;
    int width;
    int height;
    private final String SAMPLE_XML_FILE = "../../Config/SamplesConfig.xml";
    Color[] colors = new Color[]{Color.RED, Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.PINK, Color.YELLOW, Color.WHITE};

    public UserTracker() {
        try {
            this.scriptNode = new OutArg();
            this.context = Context.createFromXmlFile((String)"../../Config/SamplesConfig.xml", this.scriptNode);
            this.depthGen = DepthGenerator.create((Context)this.context);
            DepthMetaData depthMetaData = this.depthGen.getMetaData();
            this.histogram = new float[10000];
            this.width = depthMetaData.getFullXRes();
            this.height = depthMetaData.getFullYRes();
            this.imgbytes = new byte[this.width * this.height * 3];
            this.userGen = UserGenerator.create((Context)this.context);
            this.skeletonCap = this.userGen.getSkeletonCapability();
            this.poseDetectionCap = this.userGen.getPoseDetectionCapability();
            this.userGen.getNewUserEvent().addObserver((IObserver)new NewUserObserver());
            this.userGen.getLostUserEvent().addObserver((IObserver)new LostUserObserver());
            this.skeletonCap.getCalibrationCompleteEvent().addObserver((IObserver)new CalibrationCompleteObserver());
            this.poseDetectionCap.getPoseDetectedEvent().addObserver((IObserver)new PoseDetectedObserver());
            this.calibPose = this.skeletonCap.getSkeletonCalibrationPose();
            this.joints = new HashMap();
            this.skeletonCap.setSkeletonProfile(SkeletonProfile.ALL);
            this.context.startGeneratingAll();
        }
        catch (GeneralException generalException) {
            generalException.printStackTrace();
            System.exit(1);
        }
    }

    private void calcHist(ShortBuffer shortBuffer) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.histogram.length; ++n2) {
            this.histogram[n2] = 0.0f;
        }
        shortBuffer.rewind();
        n2 = 0;
        while (shortBuffer.remaining() > 0) {
            n = shortBuffer.get();
            if (n == 0) continue;
            int n3 = n;
            this.histogram[n3] = this.histogram[n3] + 1.0f;
            ++n2;
        }
        for (n = 1; n < this.histogram.length; ++n) {
            int n4 = n;
            this.histogram[n4] = this.histogram[n4] + this.histogram[n - 1];
        }
        if (n2 > 0) {
            for (n = 1; n < this.histogram.length; ++n) {
                this.histogram[n] = 1.0f - this.histogram[n] / (float)n2;
            }
        }
    }

    void updateDepth() {
        try {
            this.context.waitAnyUpdateAll();
            DepthMetaData depthMetaData = this.depthGen.getMetaData();
            SceneMetaData sceneMetaData = this.userGen.getUserPixels(0);
            ShortBuffer shortBuffer = sceneMetaData.getData().createShortBuffer();
            ShortBuffer shortBuffer2 = depthMetaData.getData().createShortBuffer();
            this.calcHist(shortBuffer2);
            shortBuffer2.rewind();
            while (shortBuffer2.remaining() > 0) {
                int n = shortBuffer2.position();
                short s = shortBuffer2.get();
                short s2 = shortBuffer.get();
                this.imgbytes[3 * n] = 0;
                this.imgbytes[3 * n + 1] = 0;
                this.imgbytes[3 * n + 2] = 0;
                if (!this.drawBackground && s == 0) continue;
                int n2 = s2 % (this.colors.length - 1);
                if (s2 == 0) {
                    n2 = this.colors.length - 1;
                }
                if (s == 0) continue;
                float f = this.histogram[s];
                this.imgbytes[3 * n] = (byte)(f * (float)this.colors[n2].getRed());
                this.imgbytes[3 * n + 1] = (byte)(f * (float)this.colors[n2].getGreen());
                this.imgbytes[3 * n + 2] = (byte)(f * (float)this.colors[n2].getBlue());
            }
        }
        catch (GeneralException generalException) {
            generalException.printStackTrace();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void getJoint(int n, SkeletonJoint skeletonJoint) throws StatusException {
        SkeletonJointPosition skeletonJointPosition = this.skeletonCap.getSkeletonJointPosition(n, skeletonJoint);
        if (skeletonJointPosition.getPosition().getZ() != 0.0f) {
            this.joints.get(n).put(skeletonJoint, new SkeletonJointPosition(this.depthGen.convertRealWorldToProjective(skeletonJointPosition.getPosition()), skeletonJointPosition.getConfidence()));
        } else {
            this.joints.get(n).put(skeletonJoint, new SkeletonJointPosition(new Point3D(), 0.0f));
        }
    }

    public void getJoints(int n) throws StatusException {
        this.getJoint(n, SkeletonJoint.HEAD);
        this.getJoint(n, SkeletonJoint.NECK);
        this.getJoint(n, SkeletonJoint.LEFT_SHOULDER);
        this.getJoint(n, SkeletonJoint.LEFT_ELBOW);
        this.getJoint(n, SkeletonJoint.LEFT_HAND);
        this.getJoint(n, SkeletonJoint.RIGHT_SHOULDER);
        this.getJoint(n, SkeletonJoint.RIGHT_ELBOW);
        this.getJoint(n, SkeletonJoint.RIGHT_HAND);
        this.getJoint(n, SkeletonJoint.TORSO);
        this.getJoint(n, SkeletonJoint.LEFT_HIP);
        this.getJoint(n, SkeletonJoint.LEFT_KNEE);
        this.getJoint(n, SkeletonJoint.LEFT_FOOT);
        this.getJoint(n, SkeletonJoint.RIGHT_HIP);
        this.getJoint(n, SkeletonJoint.RIGHT_KNEE);
        this.getJoint(n, SkeletonJoint.RIGHT_FOOT);
    }

    void drawLine(Graphics graphics, HashMap<SkeletonJoint, SkeletonJointPosition> hashMap, SkeletonJoint skeletonJoint, SkeletonJoint skeletonJoint2) {
        Point3D point3D = hashMap.get(skeletonJoint).getPosition();
        Point3D point3D2 = hashMap.get(skeletonJoint2).getPosition();
        if (hashMap.get(skeletonJoint).getConfidence() == 0.0f || hashMap.get(skeletonJoint2).getConfidence() == 0.0f) {
            return;
        }
        graphics.drawLine((int)point3D.getX(), (int)point3D.getY(), (int)point3D2.getX(), (int)point3D2.getY());
    }

    public void drawSkeleton(Graphics graphics, int n) throws StatusException {
        this.getJoints(n);
        HashMap<SkeletonJoint, SkeletonJointPosition> hashMap = this.joints.get(new Integer(n));
        this.drawLine(graphics, hashMap, SkeletonJoint.HEAD, SkeletonJoint.NECK);
        this.drawLine(graphics, hashMap, SkeletonJoint.LEFT_SHOULDER, SkeletonJoint.TORSO);
        this.drawLine(graphics, hashMap, SkeletonJoint.RIGHT_SHOULDER, SkeletonJoint.TORSO);
        this.drawLine(graphics, hashMap, SkeletonJoint.NECK, SkeletonJoint.LEFT_SHOULDER);
        this.drawLine(graphics, hashMap, SkeletonJoint.LEFT_SHOULDER, SkeletonJoint.LEFT_ELBOW);
        this.drawLine(graphics, hashMap, SkeletonJoint.LEFT_ELBOW, SkeletonJoint.LEFT_HAND);
        this.drawLine(graphics, hashMap, SkeletonJoint.NECK, SkeletonJoint.RIGHT_SHOULDER);
        this.drawLine(graphics, hashMap, SkeletonJoint.RIGHT_SHOULDER, SkeletonJoint.RIGHT_ELBOW);
        this.drawLine(graphics, hashMap, SkeletonJoint.RIGHT_ELBOW, SkeletonJoint.RIGHT_HAND);
        this.drawLine(graphics, hashMap, SkeletonJoint.LEFT_HIP, SkeletonJoint.TORSO);
        this.drawLine(graphics, hashMap, SkeletonJoint.RIGHT_HIP, SkeletonJoint.TORSO);
        this.drawLine(graphics, hashMap, SkeletonJoint.LEFT_HIP, SkeletonJoint.RIGHT_HIP);
        this.drawLine(graphics, hashMap, SkeletonJoint.LEFT_HIP, SkeletonJoint.LEFT_KNEE);
        this.drawLine(graphics, hashMap, SkeletonJoint.LEFT_KNEE, SkeletonJoint.LEFT_FOOT);
        this.drawLine(graphics, hashMap, SkeletonJoint.RIGHT_HIP, SkeletonJoint.RIGHT_KNEE);
        this.drawLine(graphics, hashMap, SkeletonJoint.RIGHT_KNEE, SkeletonJoint.RIGHT_FOOT);
    }

    @Override
    public void paint(Graphics graphics) {
        Transparency transparency;
        Object object;
        if (this.drawPixels) {
            object = new DataBufferByte(this.imgbytes, this.width * this.height * 3);
            WritableRaster writableRaster = Raster.createInterleavedRaster((DataBuffer)object, this.width, this.height, this.width * 3, 3, new int[]{0, 1, 2}, null);
            transparency = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
            this.bimg = new BufferedImage((ColorModel)transparency, writableRaster, false, null);
            graphics.drawImage(this.bimg, 0, 0, null);
        }
        try {
            object = this.userGen.getUsers();
            for (int i = 0; i < ((int[])object).length; ++i) {
                transparency = this.colors[object[i] % this.colors.length];
                transparency = new Color(255 - transparency.getRed(), 255 - transparency.getGreen(), 255 - transparency.getBlue());
                graphics.setColor((Color)transparency);
                if (this.drawSkeleton && this.skeletonCap.isSkeletonTracking(object[i])) {
                    this.drawSkeleton(graphics, object[i]);
                }
                if (!this.printID) continue;
                Point3D point3D = this.depthGen.convertRealWorldToProjective(this.userGen.getUserCoM(object[i]));
                String string = null;
                string = !this.printState ? new String("" + object[i]) : (this.skeletonCap.isSkeletonTracking(object[i]) ? new String(object[i] + " - Tracking") : (this.skeletonCap.isSkeletonCalibrating(object[i]) ? new String(object[i] + " - Calibrating") : new String(object[i] + " - Looking for pose (" + this.calibPose + ")")));
                graphics.drawString(string, (int)point3D.getX(), (int)point3D.getY());
            }
        }
        catch (StatusException statusException) {
            statusException.printStackTrace();
        }
    }

    class PoseDetectedObserver
    implements IObserver<PoseDetectionEventArgs> {
        PoseDetectedObserver() {
        }

        public void update(IObservable<PoseDetectionEventArgs> iObservable, PoseDetectionEventArgs poseDetectionEventArgs) {
            System.out.println("Pose " + poseDetectionEventArgs.getPose() + " detected for " + poseDetectionEventArgs.getUser());
            try {
                UserTracker.this.poseDetectionCap.stopPoseDetection(poseDetectionEventArgs.getUser());
                UserTracker.this.skeletonCap.requestSkeletonCalibration(poseDetectionEventArgs.getUser(), true);
            }
            catch (StatusException statusException) {
                statusException.printStackTrace();
            }
        }
    }

    class CalibrationCompleteObserver
    implements IObserver<CalibrationProgressEventArgs> {
        CalibrationCompleteObserver() {
        }

        public void update(IObservable<CalibrationProgressEventArgs> iObservable, CalibrationProgressEventArgs calibrationProgressEventArgs) {
            System.out.println("Calibraion complete: " + calibrationProgressEventArgs.getStatus());
            try {
                if (calibrationProgressEventArgs.getStatus() == CalibrationProgressStatus.OK) {
                    System.out.println("starting tracking " + calibrationProgressEventArgs.getUser());
                    UserTracker.this.skeletonCap.startTracking(calibrationProgressEventArgs.getUser());
                    UserTracker.this.joints.put(new Integer(calibrationProgressEventArgs.getUser()), new HashMap());
                } else if (calibrationProgressEventArgs.getStatus() != CalibrationProgressStatus.MANUAL_ABORT) {
                    if (UserTracker.this.skeletonCap.needPoseForCalibration()) {
                        UserTracker.this.poseDetectionCap.startPoseDetection(UserTracker.this.calibPose, calibrationProgressEventArgs.getUser());
                    } else {
                        UserTracker.this.skeletonCap.requestSkeletonCalibration(calibrationProgressEventArgs.getUser(), true);
                    }
                }
            }
            catch (StatusException statusException) {
                statusException.printStackTrace();
            }
        }
    }

    class LostUserObserver
    implements IObserver<UserEventArgs> {
        LostUserObserver() {
        }

        public void update(IObservable<UserEventArgs> iObservable, UserEventArgs userEventArgs) {
            System.out.println("Lost user " + userEventArgs.getId());
            UserTracker.this.joints.remove(userEventArgs.getId());
        }
    }

    class NewUserObserver
    implements IObserver<UserEventArgs> {
        NewUserObserver() {
        }

        public void update(IObservable<UserEventArgs> iObservable, UserEventArgs userEventArgs) {
            System.out.println("New user " + userEventArgs.getId());
            try {
                if (UserTracker.this.skeletonCap.needPoseForCalibration()) {
                    UserTracker.this.poseDetectionCap.startPoseDetection(UserTracker.this.calibPose, userEventArgs.getId());
                } else {
                    UserTracker.this.skeletonCap.requestSkeletonCalibration(userEventArgs.getId(), true);
                }
            }
            catch (StatusException statusException) {
                statusException.printStackTrace();
            }
        }
    }
}

