/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.Capability;
import org.openni.Context;
import org.openni.ErrorStateCapability;
import org.openni.GeneralException;
import org.openni.GeneralIntCapability;
import org.openni.LockHandle;
import org.openni.NativeMethods;
import org.openni.NodeInfo;
import org.openni.NodeWrapper;
import org.openni.OutArg;
import org.openni.StatusException;
import org.openni.WrapperUtils;

public class ProductionNode
extends NodeWrapper {
    ProductionNode(Context context, long l, boolean bl) throws StatusException {
        super(context, l, bl);
    }

    public static ProductionNode fromNative(long l) throws GeneralException {
        return Context.createProductionNodeFromNative(l);
    }

    public NodeInfo getInfo() throws GeneralException {
        return new NodeInfo(NativeMethods.xnGetNodeInfo(this.toNative()));
    }

    public void addNeededNode(ProductionNode productionNode) throws StatusException {
        int n = NativeMethods.xnAddNeededNode(this.toNative(), productionNode.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void removeNeededNode(ProductionNode productionNode) throws StatusException {
        int n = NativeMethods.xnRemoveNeededNode(this.toNative(), productionNode.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean isCapabilitySupported(String string) {
        return NativeMethods.xnIsCapabilitySupported(this.toNative(), string);
    }

    public void setIntProperty(String string, long l) throws StatusException {
        int n = NativeMethods.xnSetIntProperty(this.toNative(), string, l);
        WrapperUtils.throwOnError(n);
    }

    public void setRealProperty(String string, double d) throws StatusException {
        int n = NativeMethods.xnSetRealProperty(this.toNative(), string, d);
        WrapperUtils.throwOnError(n);
    }

    public void setStringProperty(String string, String string2) throws StatusException {
        int n = NativeMethods.xnSetStringProperty(this.toNative(), string, string2);
        WrapperUtils.throwOnError(n);
    }

    public void setGeneralProperty(String string, int n, long l) throws StatusException {
        int n2 = NativeMethods.xnSetGeneralProperty(this.toNative(), string, n, l);
        WrapperUtils.throwOnError(n2);
    }

    public void setGeneralProperty(String string, byte[] byArray) throws StatusException {
        int n = NativeMethods.xnSetGeneralPropertyArray(this.toNative(), string, byArray);
        WrapperUtils.throwOnError(n);
    }

    public long getIntProperty(String string) throws StatusException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnGetIntProperty(this.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        return (Long)outArg.value;
    }

    public double getRealProperty(String string) throws StatusException {
        OutArg<Double> outArg = new OutArg<Double>();
        int n = NativeMethods.xnGetRealProperty(this.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        return (Double)outArg.value;
    }

    public String getStringProperty(String string) throws StatusException {
        OutArg<String> outArg = new OutArg<String>();
        int n = NativeMethods.xnGetStringProperty(this.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        return (String)outArg.value;
    }

    public void getGeneralProperty(String string, int n, long l) throws StatusException {
        int n2 = NativeMethods.xnGetGeneralProperty(this.toNative(), string, n, l);
        WrapperUtils.throwOnError(n2);
    }

    public void getGeneralProperty(String string, byte[] byArray) throws StatusException {
        int n = NativeMethods.xnGetGeneralPropertyArray(this.toNative(), string, byArray);
        WrapperUtils.throwOnError(n);
    }

    public LockHandle lockForChanges() throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        int n = NativeMethods.xnLockNodeForChanges(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return new LockHandle((Integer)outArg.value);
    }

    public void unlockForChanges(LockHandle lockHandle) throws StatusException {
        int n = NativeMethods.xnUnlockNodeForChanges(this.toNative(), lockHandle.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void lockedNodeStartChanges(LockHandle lockHandle) throws StatusException {
        int n = NativeMethods.xnLockedNodeStartChanges(this.toNative(), lockHandle.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void lockedNodeEndChanges(LockHandle lockHandle) throws StatusException {
        int n = NativeMethods.xnLockedNodeEndChanges(this.toNative(), lockHandle.toNative());
        WrapperUtils.throwOnError(n);
    }

    public ErrorStateCapability getErrorStateCapability() throws StatusException {
        return new ErrorStateCapability(this);
    }

    public GeneralIntCapability getGeneralIntCapability(Capability capability) throws StatusException {
        return new GeneralIntCapability(this, capability);
    }
}

