/*
 * Decompiled with CFR 0.152.
 */
package org.openni.Samples.SimpleViewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ShortBuffer;
import org.openni.Context;
import org.openni.DepthGenerator;
import org.openni.DepthMetaData;
import org.openni.GeneralException;
import org.openni.OutArg;
import org.openni.ScriptNode;

class SimpleViewer
extends Component {
    private static final long serialVersionUID = 1L;
    private OutArg<ScriptNode> scriptNode;
    private Context context;
    private DepthGenerator depthGen;
    private byte[] imgbytes;
    private float[] histogram;
    private BufferedImage bimg;
    int width;
    int height;
    private final String SAMPLE_XML_FILE = "../../Config/SamplesConfig.xml";

    public SimpleViewer() {
        try {
            this.scriptNode = new OutArg();
            this.context = Context.createFromXmlFile((String)"../../Config/SamplesConfig.xml", this.scriptNode);
            this.depthGen = DepthGenerator.create((Context)this.context);
            DepthMetaData depthMetaData = this.depthGen.getMetaData();
            this.histogram = new float[10000];
            this.width = depthMetaData.getFullXRes();
            this.height = depthMetaData.getFullYRes();
            this.imgbytes = new byte[this.width * this.height];
            DataBufferByte dataBufferByte = new DataBufferByte(this.imgbytes, this.width * this.height);
            WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, this.width, this.height, 8, null);
            this.bimg = new BufferedImage(this.width, this.height, 10);
            this.bimg.setData(writableRaster);
        }
        catch (GeneralException generalException) {
            generalException.printStackTrace();
            System.exit(1);
        }
    }

    private void calcHist(DepthMetaData depthMetaData) {
        int n;
        for (int i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = 0.0f;
        }
        ShortBuffer shortBuffer = depthMetaData.getData().createShortBuffer();
        shortBuffer.rewind();
        int n2 = 0;
        while (shortBuffer.remaining() > 0) {
            n = shortBuffer.get();
            if (n == 0) continue;
            int n3 = n;
            this.histogram[n3] = this.histogram[n3] + 1.0f;
            ++n2;
        }
        for (n = 1; n < this.histogram.length; ++n) {
            int n4 = n;
            this.histogram[n4] = this.histogram[n4] + this.histogram[n - 1];
        }
        if (n2 > 0) {
            for (n = 1; n < this.histogram.length; ++n) {
                this.histogram[n] = (int)(256.0f * (1.0f - this.histogram[n] / (float)n2));
            }
        }
    }

    void updateDepth() {
        try {
            DepthMetaData depthMetaData = this.depthGen.getMetaData();
            this.context.waitAnyUpdateAll();
            this.calcHist(depthMetaData);
            ShortBuffer shortBuffer = depthMetaData.getData().createShortBuffer();
            shortBuffer.rewind();
            while (shortBuffer.remaining() > 0) {
                int n = shortBuffer.position();
                short s = shortBuffer.get();
                this.imgbytes[n] = (byte)this.histogram[s];
            }
        }
        catch (GeneralException generalException) {
            generalException.printStackTrace();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public void paint(Graphics graphics) {
        DataBufferByte dataBufferByte = new DataBufferByte(this.imgbytes, this.width * this.height);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, this.width, this.height, 8, null);
        this.bimg.setData(writableRaster);
        graphics.drawImage(this.bimg, 0, 0, null);
    }
}

