/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.Capability;
import org.openni.GeneralException;
import org.openni.MapOutputMode;
import org.openni.NativeMethods;
import org.openni.ObjectWrapper;
import org.openni.OutArg;
import org.openni.ProductionNode;
import org.openni.StatusException;
import org.openni.Version;
import org.openni.WrapperUtils;

public class Query
extends ObjectWrapper {
    public Query() throws GeneralException {
        super(Query.allocate());
    }

    public void setVendor(String string) throws StatusException {
        int n = NativeMethods.xnNodeQuerySetVendor(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public void setName(String string) throws StatusException {
        int n = NativeMethods.xnNodeQuerySetName(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public void setMinVersion(Version version) throws StatusException {
        int n = NativeMethods.xnNodeQuerySetMinVersion(this.toNative(), version.getMajor(), version.getMinor(), version.getMaintenance(), version.getBuild());
        WrapperUtils.throwOnError(n);
    }

    public void setMaxVersion(Version version) throws StatusException {
        int n = NativeMethods.xnNodeQuerySetMaxVersion(this.toNative(), version.getMajor(), version.getMinor(), version.getMaintenance(), version.getBuild());
        WrapperUtils.throwOnError(n);
    }

    public void addSupportedCapability(Capability capability) throws StatusException {
        int n = NativeMethods.xnNodeQueryAddSupportedCapability(this.toNative(), capability.getName());
        WrapperUtils.throwOnError(n);
    }

    public void addSupportedMapOutputMode(MapOutputMode mapOutputMode) throws StatusException {
        int n = NativeMethods.xnNodeQueryAddSupportedMapOutputMode(this.toNative(), mapOutputMode.getXRes(), mapOutputMode.getYRes(), mapOutputMode.getFPS());
        WrapperUtils.throwOnError(n);
    }

    public void addSupportedMinUserPositions(int n) throws StatusException {
        int n2 = NativeMethods.xnNodeQuerySetSupportedMinUserPositions(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void setExistingNodeOnly(boolean bl) throws StatusException {
        int n = NativeMethods.xnNodeQuerySetExistingNodeOnly(this.toNative(), bl);
        WrapperUtils.throwOnError(n);
    }

    public void setNonExistingNodeOnly(boolean bl) throws StatusException {
        int n = NativeMethods.xnNodeQuerySetNonExistingNodeOnly(this.toNative(), bl);
        WrapperUtils.throwOnError(n);
    }

    public void addNeededNode(ProductionNode productionNode) throws StatusException {
        int n = NativeMethods.xnNodeQueryAddNeededNode(this.toNative(), productionNode.getName());
        WrapperUtils.throwOnError(n);
    }

    public void setCreationInfo(String string) throws StatusException {
        int n = NativeMethods.xnNodeQuerySetCreationInfo(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    @Override
    protected void freeObject(long l) {
        NativeMethods.xnNodeQueryFree(l);
    }

    private static long allocate() throws StatusException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnNodeQueryAllocate(outArg);
        WrapperUtils.throwOnError(n);
        return (Long)outArg.value;
    }
}

