/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.BoundingBox3D;
import org.openni.CapabilityBase;
import org.openni.IStateChangedObservable;
import org.openni.NativeMethods;
import org.openni.OutArg;
import org.openni.Point3D;
import org.openni.ProductionNode;
import org.openni.StateChangedObservable;
import org.openni.StatusException;
import org.openni.WrapperUtils;

public class UserPositionCapability
extends CapabilityBase {
    private StateChangedObservable userPositionChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToUserPositionChange(UserPositionCapability.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromUserPositionChange(UserPositionCapability.this.toNative(), l);
        }
    };

    public UserPositionCapability(ProductionNode productionNode) throws StatusException {
        super(productionNode);
    }

    public int getSupportedCount() {
        return NativeMethods.xnGetSupportedUserPositionsCount(this.toNative());
    }

    public void setUserPosition(int n, BoundingBox3D boundingBox3D) throws StatusException {
        Point3D point3D = boundingBox3D.getLeftBottomNear();
        Point3D point3D2 = boundingBox3D.getRightTopFar();
        int n2 = NativeMethods.xnSetUserPosition(this.toNative(), n, point3D.getX(), point3D.getY(), point3D.getZ(), point3D2.getX(), point3D2.getY(), point3D2.getZ());
        WrapperUtils.throwOnError(n2);
    }

    public BoundingBox3D getUserPosition(int n) throws StatusException {
        OutArg<BoundingBox3D> outArg = new OutArg<BoundingBox3D>();
        int n2 = NativeMethods.xnGetUserPosition(this.toNative(), n, outArg);
        WrapperUtils.throwOnError(n2);
        return (BoundingBox3D)outArg.value;
    }

    public IStateChangedObservable getUserPositionChangedEvent() {
        return this.userPositionChanged;
    }
}

