/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.openni.NativeMethods;

public class Map {
    protected long ptr;
    protected int xRes;
    protected int yRes;
    protected int bytesPerPixel;

    Map() {
    }

    Map(long l, int n, int n2, int n3) {
        this.ptr = l;
        this.xRes = n;
        this.yRes = n2;
        this.bytesPerPixel = n3;
    }

    public long getNativePtr() {
        return this.ptr;
    }

    public void setNativePtr(long l) {
        this.ptr = l;
    }

    protected ByteBuffer createByteBuffer() {
        int n = this.xRes * this.yRes * this.bytesPerPixel;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        NativeMethods.copyToBuffer(byteBuffer, this.ptr, n);
        return byteBuffer;
    }

    public void copyToBuffer(ByteBuffer byteBuffer, int n) {
        NativeMethods.copyToBuffer(byteBuffer, this.ptr, n);
    }

    protected long getPixelPtr(int n, int n2) {
        return this.ptr + (long)((n2 * this.xRes + n) * this.bytesPerPixel);
    }

    public int getXRes() {
        return this.xRes;
    }

    public void setXRes(int n) {
        this.xRes = n;
    }

    public int getYRes() {
        return this.yRes;
    }

    public void setYRes(int n) {
        this.yRes = n;
    }

    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    protected void setBytesPerPixel(int n) {
        this.bytesPerPixel = n;
    }
}

