/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.NullEventArgs;
import com.primesense.NITE.PointControl;
import org.OpenNI.GeneralException;
import org.OpenNI.IObservable;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class WaveDetector
extends PointControl {
    private Observable<NullEventArgs> waveEvent = new Observable<NullEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvWaveDetector_RegisterWave(WaveDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvWaveDetector_UnregisterWave(WaveDetector.this.toNative(), l);
        }

        public void callback() {
            this.notify((Object)new NullEventArgs());
        }
    };

    public WaveDetector(String string) throws GeneralException {
        super(NativeMethods.xnvWaveDetector_Create(string));
    }

    public WaveDetector() throws GeneralException {
        this("");
    }

    @Override
    protected void freeObject() {
        super.freeObject();
        NativeMethods.xnvWaveDetector_Destroy(this.toNative());
    }

    public void reset() throws StatusException {
        int n = NativeMethods.xnvWaveDetector_Reset(this.toNative());
        WrapperUtils.throwOnError((int)n);
    }

    public void setFlipCount(int n) throws StatusException {
        int n2 = NativeMethods.xnvWaveDetector_SetFlipCount(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public void SetMinLength(int n) throws StatusException {
        int n2 = NativeMethods.xnvWaveDetector_SetMinLength(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public void SetMaxDeviation(int n) throws StatusException {
        int n2 = NativeMethods.xnvWaveDetector_SetMaxDeviation(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public int getFlipCount() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvWaveDetector_GetFlipCount(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public int getMinLength() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvWaveDetector_GetMinLength(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public int getMaxDeviation() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvWaveDetector_GetMaxDeviation(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public IObservable<NullEventArgs> getWaveEvent() {
        return this.waveEvent;
    }
}

