/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.MessageGenerator;
import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.NullEventArgs;
import com.primesense.NITE.PointEventArgs;
import com.primesense.NITE.StringPointValueEventArgs;
import org.OpenNI.GeneralException;
import org.OpenNI.IObservable;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class SessionGenerator
extends MessageGenerator {
    private Observable<PointEventArgs> sessionStartEvent = new Observable<PointEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvSessionGenerator_RegisterToSessionStart(SessionGenerator.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvSessionGenerator_UnregisterFromSessionStart(SessionGenerator.this.toNative(), l);
        }

        public void callback(Point3D point3D) {
            this.notify((Object)new PointEventArgs(point3D));
        }
    };
    private Observable<NullEventArgs> sessionEndEvent = new Observable<NullEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvSessionGenerator_RegisterToSessionEnd(SessionGenerator.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvSessionGenerator_UnregisterFromSessionEnd(SessionGenerator.this.toNative(), l);
        }

        public void callback() {
            this.notify((Object)new NullEventArgs());
        }
    };
    private Observable<StringPointValueEventArgs> sessionFocusProgressEvent = new Observable<StringPointValueEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvSessionGenerator_RegisterToSessionFocusProgress(SessionGenerator.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvSessionGenerator_UnregisterFromSessionFocusProgress(SessionGenerator.this.toNative(), l);
        }

        public void callback(String string, Point3D point3D, float f) {
            this.notify((Object)new StringPointValueEventArgs(string, point3D, f));
        }
    };

    public SessionGenerator(long l) throws GeneralException, StatusException {
        super(l);
    }

    @Override
    protected void freeObject() {
        super.freeObject();
    }

    public void LosePoint(int n) throws StatusException {
        int n2 = NativeMethods.xnvSessionGenerator_LosePoint(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public void LosePoints() throws StatusException {
        int n = NativeMethods.xnvSessionGenerator_LosePoints(this.toNative());
        WrapperUtils.throwOnError((int)n);
    }

    public void EndSession() throws StatusException {
        int n = NativeMethods.xnvSessionGenerator_EndSession(this.toNative());
        WrapperUtils.throwOnError((int)n);
    }

    public void ForceSession(Point3D point3D) throws StatusException {
        int n = NativeMethods.xnvSessionGenerator_ForceSession(this.toNative(), point3D.getX(), point3D.getY(), point3D.getZ());
        WrapperUtils.throwOnError((int)n);
    }

    public void TrackPoint(Point3D point3D) throws StatusException {
        int n = NativeMethods.xnvSessionGenerator_TrackPoint(this.toNative(), point3D.getX(), point3D.getY(), point3D.getZ());
        WrapperUtils.throwOnError((int)n);
    }

    public boolean IsInSession() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSessionGenerator_IsInSession(this.toNative(), (OutArg<Boolean>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Boolean)outArg.value;
    }

    public Point3D GetFocusPoint() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSessionGenerator_GetFocusPoint(this.toNative(), (OutArg<Point3D>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Point3D)outArg.value;
    }

    public IObservable<PointEventArgs> getSessionStartEvent() {
        return this.sessionStartEvent;
    }

    public IObservable<NullEventArgs> getSessionEndEvent() {
        return this.sessionEndEvent;
    }

    public IObservable<StringPointValueEventArgs> getSessionFocusProgressEvent() {
        return this.sessionFocusProgressEvent;
    }
}

