/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.PowerLineFrequency;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class AntiFlickerCapability
extends CapabilityBase {
    private StateChangedObservable powerLineFrequencyChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToPowerLineFrequencyChange(AntiFlickerCapability.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromPowerLineFrequencyChange(AntiFlickerCapability.this.toNative(), l);
        }
    };

    public AntiFlickerCapability(ProductionNode productionNode) throws StatusException {
        super(productionNode);
    }

    public PowerLineFrequency getPowerLineFrequency() {
        return PowerLineFrequency.fromNative(NativeMethods.xnGetPowerLineFrequency(this.toNative()));
    }

    public void setPowerLineFrequency(PowerLineFrequency powerLineFrequency) throws StatusException {
        int n = NativeMethods.xnSetPowerLineFrequency(this.toNative(), powerLineFrequency.toNative());
        WrapperUtils.throwOnError(n);
    }

    public IStateChangedObservable getPowerLineFrequencyChangedEvent() {
        return this.powerLineFrequencyChanged;
    }
}

