/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;

public class ErrorStateCapability
extends CapabilityBase {
    private StateChangedObservable errorStateChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToNodeErrorStateChange(ErrorStateCapability.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromNodeErrorStateChange(ErrorStateCapability.this.toNative(), l);
        }
    };

    public ErrorStateCapability(ProductionNode productionNode) throws StatusException {
        super(productionNode);
    }

    public String getErrorState() {
        int n = NativeMethods.xnGetNodeErrorState(this.toNative());
        if (n == 0) {
            return null;
        }
        return NativeMethods.xnGetStatusString(n);
    }

    public IStateChangedObservable getErrorStateChangedEvent() {
        return this.errorStateChanged;
    }
}

