/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.ImageMap;
import org.OpenNI.ImageMetaData;
import org.OpenNI.MapGenerator;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.PixelFormat;
import org.OpenNI.Query;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class ImageGenerator
extends MapGenerator {
    private ImageMap currImageMap;
    private int currImageMapFrameID;
    private StateChangedObservable pixelFormatChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToPixelFormatChange(ImageGenerator.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromPixelFormatChange(ImageGenerator.this.toNative(), l);
        }
    };

    ImageGenerator(Context context, long l, boolean bl) throws GeneralException {
        super(context, l, bl);
    }

    public static ImageGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateImageGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        ImageGenerator imageGenerator = (ImageGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.IMAGE);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return imageGenerator;
    }

    public static ImageGenerator create(Context context, Query query) throws GeneralException {
        return ImageGenerator.create(context, query, null);
    }

    public static ImageGenerator create(Context context) throws GeneralException {
        return ImageGenerator.create(context, null, null);
    }

    public boolean isPixelFormatSupported(PixelFormat pixelFormat) {
        return NativeMethods.xnIsPixelFormatSupported(this.toNative(), pixelFormat.toNative());
    }

    public void setPixelFormat(PixelFormat pixelFormat) throws StatusException {
        int n = NativeMethods.xnSetPixelFormat(this.toNative(), pixelFormat.toNative());
        WrapperUtils.throwOnError(n);
    }

    public PixelFormat getPixelFormat() {
        return PixelFormat.fromNative(NativeMethods.xnGetPixelFormat(this.toNative()));
    }

    public ImageMap getImageMap() throws GeneralException {
        int n = this.getFrameID();
        if (this.currImageMap == null || this.currImageMapFrameID != n) {
            long l = NativeMethods.xnGetImageMap(this.toNative());
            MapOutputMode mapOutputMode = this.getMapOutputMode();
            this.currImageMap = new ImageMap(l, mapOutputMode.getXRes(), mapOutputMode.getYRes(), NativeMethods.xnGetBytesPerPixel(this.toNative()));
            this.currImageMapFrameID = n;
        }
        return this.currImageMap;
    }

    public IStateChangedObservable getPixelFormatChangedEvent() {
        return this.pixelFormatChanged;
    }

    public void getMetaData(ImageMetaData imageMetaData) {
        NativeMethods.xnGetImageMetaData(this.toNative(), imageMetaData);
    }

    public ImageMetaData getMetaData() {
        ImageMetaData imageMetaData = new ImageMetaData();
        this.getMetaData(imageMetaData);
        return imageMetaData;
    }
}

