/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class AlternativeViewpointCapability
extends CapabilityBase {
    private StateChangedObservable viewPointChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToViewPointChange(AlternativeViewpointCapability.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromViewPointChange(AlternativeViewpointCapability.this.toNative(), l);
        }
    };

    public AlternativeViewpointCapability(ProductionNode productionNode) throws StatusException {
        super(productionNode);
    }

    public boolean isViewpointSupported(ProductionNode productionNode) {
        return NativeMethods.xnIsViewPointSupported(this.toNative(), productionNode.toNative());
    }

    public void setViewpoint(ProductionNode productionNode) throws StatusException {
        int n = NativeMethods.xnSetViewPoint(this.toNative(), productionNode.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void resetViewpoint() throws StatusException {
        int n = NativeMethods.xnResetViewPoint(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean isViewpointAs(ProductionNode productionNode) {
        return NativeMethods.xnIsViewPointAs(this.toNative(), productionNode.toNative());
    }

    public IStateChangedObservable getViewPointChangedEvent() {
        return this.viewPointChanged;
    }
}

