/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.DeviceIdentificationCapability;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.Query;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class Device
extends ProductionNode {
    public Device(Context context, long l, boolean bl) throws StatusException {
        super(context, l, bl);
    }

    public static Device create(Context context, Query query, EnumerationErrors enumerationErrors) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateDevice(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        Device device = (Device)context.createProductionNodeObject((Long)outArg.value, NodeType.DEVICE);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return device;
    }

    public static Device create(Context context, Query query) throws GeneralException {
        return Device.create(context, query, null);
    }

    public static Device create(Context context) throws GeneralException {
        return Device.create(context, null, null);
    }

    public DeviceIdentificationCapability getDeviceIdentificationCapability() throws StatusException {
        return new DeviceIdentificationCapability(this);
    }
}

