% NB : this file include the analyses level, 
% (such that only one m-file is necessary)
%---------------------------------------------------------------

%---------------------------------------------------------------
% batch variables defined here for analysis 'analyses'
%---------------------------------------------------------------

analyses = struct( ... 
      'type', 		[1 1 1], ...
      'index', 		[1 2 1], ...
      'work_dir', 	[1 1 2], ...
      'mfile', 		[1 1 2] ...
);

%---------------------------------------------------------------

type = {'defaults_edit','model','contrasts','headers',...
'means','realignment','normalisation','smooth'};

%---------------------------------------------------------------

work_dir = {'/home/spm/spm99b/spm_devel_bch/exemples',...
	    '/home/spm/spm99b/spm_devel_bch/exemples'...
           };

%---------------------------------------------------------------
% file names are either full pathname or relative to work_dir

mfile = {'./default_bch_ex',...
	'./default_bch_ex',...
        };

%---------------------------------------------------------------


%---------------------------------------------------------------
% batch variables defined here for analysis 'defaults_edit'
%---------------------------------------------------------------

defaults_edit(1) = struct( ...
   'type_area', [1 1 3], ...
   'index', 	[1 2 1] ...
);

defaults_edit(2) = struct( ...
   'type_area', 4, ...
   'index', 	1 ...
);

type_area = {'Misc','Printing','Hdr','Statistics', ...
		 'Normalisation','RealignCoreg','Reset'};

%====================== Misc Defaults
Misc = struct( ...
   'log_to_file', 0, ...
   'log_file_name', '', ...
   'cmdline', 0, ...
   'grid', 0.1 ...
);
Misc(2) = Misc(1);
Misc(2).log_file_name = 'toto';

%====================== Printing Defaults
Printing = struct( ...
   'printing_mode', 1,  ...
   'postscript_filename', 'blablabla',  ...
   'postscript_type', 1,  ...
   'default_printer', 0,  ...
   'printer_name', '',  ...
   'post_type', '-dps',  ...
   'graphics_filename', '',  ...
   'graph_type', 3,  ...
   'print_string', '' ...
);

%====================== Header Defaults
Hdr = struct( ...
   'defaults_area',  3, ...
   'image_size_voxels',  '10 20 30', ...
   'voxel_size_mm',  '4 4 4', ...
   'scale',  1, ...
   'data_type',  16, ...
   'offset',  0, ...
   'origin_voxels',  '1 1 1', ...
   'description',  'oufff' ...
);

%====================== RealignCoreg Defaults
RealignCoreg = struct( ...
   'defaults_area',  4 ...
);

%====================== Normalisation Defaults
Normalisation = struct( ...
   'defaults',  1, ...
   'estimates',  1, ...
   'custom_estimates',  ones(1,12), ...
   'custom_norm',  1, ...
   'nonlin_func_nb', 2, ...
   'func_nb',  0, ...
   'nonlin_ite_nb',  1, ...
   'nonlin_regular',  0.0001, ...
   'mask_brain',  0, ...
   'mask_object_brain',  0, ...
   'bounding_box',  1, ...
   'voxel_sizes',  -1 ...
);


%====================== Statistics Defaults
Statistics = struct( ...
   'fMRI_T', 	   16, ...
   'fMRI_T0', 	   1, ...
   'F_threshold',  1 ...
);

%====================== Reset Defaults
