%---------------------------------------------------------------
% user variables defined here 
%---------------------------------------------------------------

%---------------------------------------------------------------
% batch variables defined here for analysis 'realign'
%---------------------------------------------------------------

realign = struct(...
'subject_nb', 1, ...
'num_sessions', [1], ...
'sessions', [1], ...
'option', 1, ...
'modality', 1, ...
'reslice_method', 2, ...
'create', 1, ...
'mask', 0, ...
'adjust_sampling_errors', 0);

realign(2:3) = realign(1);
realign(2).option = 2;
realign(3).option = 3;

%---------------------------------------------------------------
% batch variables defined here for analysis 'normalize'
%---------------------------------------------------------------


normalize = struct(...
'option', 1, ...
'nbsubjects', 1, ...
'object_masking', 0, ...
'image', {{'/home/poline/bch_devel/test/ima3_1010.img'}}, ...
'objmask', {{''}}, ...
'matname', {{'ima3_1010_sn3d.mat'}}, ...
'images', {{'/home/poline/bch_devel/test/ima3_1010.img'}}, ...
 'template', '/home/poline/spm_devel/templates/T2.img', ...
'type', 0, ...
'nonlin_func_nb', 3, ...
'func_nb', 0, ...
'nonlin_ite_nb', 1, ...
'nonlin_regular', 0.0001, ...
'mask_brain', 0, ...
'interp', 0, ...
'bounding_box', 1, ...
'direction1', [-10;10], ...
'direction2', [-10;10], ...
'direction3', [-10;10], ...
'voxel_sizes', 0, ...
'voxel_sizes_custom', [2 2 2]);

normalize(2:3) = normalize(1);
normalize(2).option = 2;
normalize(3).option = 3;
normalize(2).type = 1;
normalize(3).mask_brain = 1;
normalize(2).interp = 1;
normalize(3).interp = -9;


sessions(1) = struct(...
'images', {{['ima3_1010.img';'ima3_1011.img']}});

sessions(2) = struct(...
'images', {{['ima3_1010.img';'ima3_1011.img'], ...
            ['ima3_1012.img';'ima3_1013.img']}});

defaults_edit = struct( ...
'type_area', [1], ...
'index', [1] ...
);

%---------------------------------------------------------------
% batch variables defined here for analysis 'defaults_edit'
%---------------------------------------------------------------


defaults_edit(1) = struct(...
'type_area', [1 2 2], ...
'index', [1 1 2] ...
);

defaults_edit(2) = defaults_edit(1);

type_area = {'RealignCoreg','Normalisation'};

RealignCoreg = struct( ...
'separate_combine' , 1, ...
'create' , 1, ...
'adjust', 1, ...
'mask', -1, ...
'reg_quality', 0.0001 ...
);

Normalisation(1) = struct( ...
'defaults', 1, ...
'estimates', 1, ...
'custom_estimates', ones(1,12), ...
'custom_norm', 1, ...
'nonlin_func_nb', 2, ...
'func_nb', 0, ...
'nonlin_ite_nb', 1, ...
'nonlin_regular', 0.0001, ...
'mask_brain', 0, ...
'mask_object_brain', 0 ...
);

Normalisation(2).defaults = 0;
Normalisation(2).bounding_box = 1;
Normalisation(2).voxel_sizes = -1; 




