
% SPM batch system
%_______________________________________________________________________
%                                                    BATCH_DOCUMENTATION
% 
% How to read this documentation? 
%     1 - read the [GETTING_STARTED] section 
%     2 - when you encounter a [KEY_WORD] 
%         then look for this key work to get exemples or details 
%         on the KEY_WORD subject.
%
%
% [BCH_EX_DIR] = ~spm/spm_devel/batch/examples
%_______________________________________________________________________
% @(#)spm_bch.man	2.6 JB Poline & Stephanie Rouquette 99/10/27
%
%
%
%
%
%_______________________________________________________________________
%                                                      [GETTING_STARTED]
%
% The batch system relies on a description of all parameters
% that need to be entered in the graphic user interface.
% In short, you will need to write a description of what 
% kind of analyses you wish to perform in a text file (a "m-file)
% say for instance "analyses_bch_ex.m".
%
% There are exemples of such files in [BCH_EX_DIR]
%
% The simplest is to copy an existing analyses_bch_ex.m file and
% modify it depending on your specific needs.
% "analyses_bch_ex.m" should contain something like:
%  (exemples of m-files are shown in double include marks: '% |')
%
% [MFILE_EX]____________________________________________________________
% | %---------------------------------------------------------------
% | analyses = struct( ... 
% |      'type',        [1 1 2], ...
% |      'work_dir',    [1 2 1], ...
% |      'mfile',       [1 1 1] ...
% |      'index',       [1 2 1], ...
% | );
% | %---------------------------------------------------------------
% | type = {'model','contrasts','defaults_edit','headers',...
% |       'means','realign','normalize','smooth'};
% | %---------------------------------------------------------------
% | work_dir = { ...
% |       '/home/jbp/test1',...
% |       '/home/jbp/test2',...
% |           };
% | %---------------------------------------------------------------
% | mfile = { ...
% |        './exemples/model_bch_ex',...
% |        };
% | %---------------------------------------------------------------
%
%
% The type of analysis will be specified by analyses.type
% and the variable type, such that 
%
% the first analysis is 
%    type(analyses.type(1)) (which is 'model') 
% the second analysis is 
%    type(analyses.type(2)) (which is 'model')
% the third analysis is 
%    type(analyses.type(3)) (which is 'contrasts')
% (see [TYPE_OF_ANALYSIS] )
%
% The first analysis will be performed in the directory :
%    work_dir(analyses.work_dir(1)) (which is '/home/jbp/test1')
% The second analysis will be performed in the directory :
%    work_dir(analyses.work_dir(2)) (which is '/home/jbp/test2')
% and so on ...
% This is refered to as the [INDEXING_SYSTEM].
%
% The Nth analysis will find the parameters required in the 
% m-file specified in the variable mfile : 
%
%    mfile(analyses.mfile(Nth)) (which is always 
%       './exemples/model_bch_ex' in this exemple) 
%       NB : file's path can be complete path. When relative, 
%       they are relative with respect to the working directory  
%       work_dir(analyses.work_dir(Nth))
% 
% So in this exemple, the 'model' and 'contrasts' analyses will have
% find their input in '/home/jbp/test1/./exemples/model_bch_ex'
% specified in the same m-file (since analyses.mfile(1, 2 and 3) is 1, 
% therefore addressing all mfile(1).
%
% Now, the first two analyses are 'model'. But they may not be the same
% model. The index field tells you that the first model parameters
% will be found in model(1) and the second in model(2). (see the
% description of 'model_bch_ex.m' and [MODEL]). This allows multiple analyses
% of the same kind with a minimum of specification (see [INDEXING_SYSTEM]).
%
% This is what model_bch_ex.m may look like : 
%
% [MFILE_EX]____________________________________________________________
% | %---------------------------------------------------------------
% | % user variables defined here 
% | %---------------------------------------------------------------
% | 
% | 
% | p = '/home/shallice/Rik/SPM99course/CatStats/params.mat'
% | load(p);
% | F1=spm_get('files','/home/shallice/Rik/SPM99course/Smooth_snraf','sn*.img');
% | 
% | z=zeros(1,8);
% | c1 = [1 0 1 0 1 0 1 0 0 0   0];
% | c2 = -c1;
% | 
% | cond_names = {'n1','n2','f1','f2','target'}
% | 
% | o1 = [ 4.7451  6.7451 10.9902 13.2353 14.5000 20.5000 26.7451];
% | o2 = [28.7451 37.2353 46.7451 54.9902 56.9902 59.2353 68.7451];
% | 
% | 
% | 
% | %---------------------------------------------------------------
% | % batch variables defined here for analysis 'model'
% | %---------------------------------------------------------------
% | 
% | %---------------------------------------------------------------
% | 
% | model(1) = struct( ...
% |  'types',          1, ...
% |  'global_effects', {'Scaling'}, ...
% |  'burst_mode',     0, ...
% |  'HF_fil',         'specify',  ...
% |  'HF_cut',         [232 232], ...
% |  'LF_fil',         'Gaussian', ...
% |  'LF_cut',         4, ...
% |  'int_corr',       'none', ... 
% |  'trial_fcon',     0, ...
% |  'now_later',      1, ...
% |  'stop_writing',   0, ...
% |  'RT',             4.1, ...
% |  'replicated',     0, ...
% |  'nsess',          2, ...
% |  'nscans',         [100 200], ...
% |  'files',          {{F1 F1}}, ...
% | 'conditions_nb',  [5 2], ...     
% |  'conditions',     [1 2], ...
% |  'regressors_nb',  [0 0], ...
% |  'regressors',     [], ...
% |  'parametrics_type', {{'none','none'}}, ...
% |  'parametrics',    [] ...
% |  'stochastics_flag', [0 0], ...
% |  'stochastics',    [], ...
% | );
% | 
% | model(2) =  model(1);
% | model(2).HF_cut = [232];
% | model(2).nscans = [100];
% | model(2).files = {{F1}};
% | model(2).conditions_nb = [5];     
% | model(2).conditions = [1];
% | model(2).regressors_nb = [0];
% | model(2).parametrics_type = {{'none'}};
% | model(2).stochastics_flag = [0];
% | model(2).stochastics = [];
% | 
% | %---------------------------------------------------------------
% |  
% | conditions(1) = struct( ...
% |  'names',   {cond_names}, ...
% |  'onsets',  {sot}, ...   
% |  'types',    {{'events','events','events','events','events'}}, ... 
% |  'bf_ev',   [1 2 1 1 1], ...
% |  'bf_ep',   [0 0 0 0 0], ...
% |  'volterra',  0, ...
%    'variable_dur', 0 ...
% | );
% | 
% | 
% | conditions(2) = conditions(1);
% | conditions(2).names = {'n1','n2'};
% | conditions(2).onsets = {o1, o2};
% | conditions(2).types = {{'events','events'}};
% | conditions(2).bf_ev = [1 0];
% | conditions(2).bf_ep = [0 1];
% | 
% | %---------------------------------------------------------------
% | 
% | bf_ev(1) = struct( ...
% |   'ev_type', 2, ...
% |   'win_len', [] ...
% | );
% | bf_ev(2) = bf_ev(1) ;
% | bf_ev(2).ev_type = 1;
% | 
% | bf_ep(1) = struct( ...
% |   'ep_type', 4, ...
% |   'length',3 ...
% |   'conv',  1, ...  
% |   'deriv', 0 ...
% | );
% | 
% | %---------------------------------------------------------------
% | % batch variables defined here for analysis 'contrasts'
% | %---------------------------------------------------------------
% | 
% | contrasts(1) = struct( ...
% |    'names',  {{'c1','c2'}}, ...
% |    'types',   {{'T','F'}}, ...
% |    'values',  {{c1,c2}} ...
% | );
% 
%
% There are 3 distinct parts in this file :
%
% 1- a user defined variable section, to load all variables you 
% may have (for instance some 'load file.txt', or 'load file.mat')
%
% 2- a description of the 'model' analyses that will be performed.
% through the variables model, conditions, bf_ev and bf_ep. ([MODEL])
% The full description of each variable can be found below in the 
% VARIABLE_DESCRIPTION section.
%
% 3- a description of the 'contrasts' analysis (see [CONTRASTS], and
% see the note about the size of the contrasts that must include
% block effects)
%
% Basically, model(1).types is the GUI choice of 'review, specify, 
% estimate...'(see VARIABLE_DESCRIPTION model types).
% Most parameter in this structure are intuitive if you're familiar
% with spm99b GUI. 
% What you have to know :
%
% HF_cut : there must be as many as session (it's an array)
%
% files : F1 and F2 are variable defined in the user section. 
%       (name them as you like !). There must be as many as 
%       sessions as well. Be careful to enclose a series of
%       variables with TWO curly braket, like in {{F1,F2}} 
%       if model is defined with a 'model = struct( ... );'     
%       However, if defined with a 'model(1).file = {F1,F2}'
%       only one pair of {} is needed. 
%       THIS IS A GENERAL POINT THAT APPLIES TO ALL VARIABLES
%       (not only 'model').
%       Note that spm_get('files',dir,fil) is useful here to get the files.
% 
% conditions : there should be as many as files or HF_cut.
%       This array represents an index to the variable 'conditions'.
%       This 'conditions' variable will describe a series of conditions.
%       (and is therefore homologous to a "session" in fMRI)
%       In this exemple, the description of the first session 
%       is found in conditions(model(1).conditions(1)) and that of the 
%       second session in conditions(model(1).conditions(1)) 
%       This is refered to as the [INDEXING_SYSTEM]
%
% The variable 'conditions' ([CONDITIONS]) follows the same principle.
% 'names' 'onsets' 'bf_ev' and  'bf_ep' should be of the same
% length. bf_ev(conditions(k).bf_ev(j)) describes the model for the jth 
% event for the session which description is in conditions(k). ([BF_EV]). 
% 
% 
% NB: Not all variables need to exist in the m-files and 
% fields of variables can be empty or not existing (documentation is a bit
% loose on that subject). In general, just specify what you would have 
% entered in the GUI. 
% 
% Once the appropriate m-files have been defined, simply launch 
%      spm_bch('m-file','FMRI')
% or   spm_bch('m-file')
% in matlab5 (no PET version for the moment)
%
% HOWEVER, IT IS SUGGESTED THAT YOU CHECK CAREFULLY YOUR M-FILE
% BEFORE LAUCHING SPM_BCH : 
% TRY TO EXECUTE YOUR M-FILES BEFORE AND CHECK THAT EVERY THING
% IS OK AT THAT STAGE
%
%_______________________________________________________________________
%                                                     [TYPE_OF_ANALYSIS]
%
% Possible analyses for the moment are :
% [MODEL]          : specify, estimate a model 
% [CONTRASTS]      : compute some contrasts
% [HEADERS]        : change some headers
% [MEANS]          : compute some means
% [DEFAULTS_EDIT]  : change the defaults 
% [SMOOTH]         : smooth some images
% [REALIGN]        : realign some images   
% [NORMALISATION]  : normalize some images  
%
%_______________________________________________________________________
%                                                      [INDEXING_SYSTEM]
%
% When variable described in parameter mfiles are structures and when a
% field of the structure has the name of an other variable in the
% parameter mfile, the values of the array found at the field will
% index the variable with the same name.
% 
% For instance, the "model(1)" structure has a conditions field, say [1
% 2 1]. This means that the first series of conditions will be found in
% conditions(1), the second in condition(2) and the third in
% conditions(1).  This avoid duplication of information in the
% parameter file.  This principle is recursive. Notice that in general,
% the variable name refers to a SERIES of ... For instance, 'contrasts'
% refers to a series of contrasts, and so on...  This allows a quicker
% specification in most of the case.  Not all variables need to exist
% (eg, regressors, parametrics ...  need not exist in the m-file if not
% used for the model specification).
% 
% More generally, assume we have a parent variable called 'parent_var'
% with field 'child_variable', then
%       Indices = parent_var(k).child_variable
% and for all 'Ind' in 'Indices', child_variable(Ind) must exist.
% Exeption to this rule : Indices can sometime contain 0 (in this case
% the indices are also used as boulean variable. But in general, they
% should be valid indices.
%
%
%_______________________________________________________________________
%                                                 [VARIABLE_DESCRIPTION]
%
% variables or variables fields possible values  
% are described as either one of the following
% type, or as a list of string (eg {'linear','exponen','polynom'}
% When there is a 'y/n',[1 0] or of the kind, this means that
% you have to enter 1 (for yes) or 0 (for no).  
%
% [UNIQUE]         : refers to the fields that take a unique value,
%                    such that length(variable(Nth).field) == 1
% [MULTIPLE]       : refers to the field that have length >= 1
%               NB : the fields under the [MULTIPLE] section should have
%                    the SAME length
%
%_______________________________________________________________________
%                                            [VARIABLE_TYPE_DESCRIPTION]
%
%
% INDICES          : These are used for the [INDEXING_SYSTEM]
%                    in general should be valid indices to a child var.
% VALUE            : a single value, eg 1.7
% INTEGER          : an integer value 
% INTEGER_ARRAY    : an array of integers (eg [ 1 1 1 ])
% STRING           : a string
% STRINGS          : cell array of strings, like {'aa','bb',...}
% STRING_ARRAY     : array of strings : ['file001.img';'file001.img';...]
%                    (like the output of spm_get)
% STRING_ARRAYS    : cell array of STRING_ARRAY
% VALUE_ARRAY      : array of values, eg [1.2 6 12 432]
% VALUE_ARRAYS     : cell array of VALUE_ARRAY
% ARRAY            : a matrix
%
%_______________________________________________________________________
%                                                              [NOTE_ON]
%       [ANALYSES]
%          
%       [MODEL] 
%          
%       [HEADERS]
%          current parameters are kept if empty fields   
%          (empty fields are necessary ...)
%          
%
%_______________________________________________________________________
%
%
%
%
%=========================================================================
% [ANALYSES] 
%=========================================================================
%
% analyses : STRUCT % [ANALYSES]
%----------------------------------------
%................[MULTIPLE]................
%  'type',       INDICES
%  'index',      INDICES
%  'mfile',      INDICES
%  'work_dir',   INDICES               
%----------------------------------------
%----------------------------------------
% type : STRINGS % [TYPE]
%----------------------------------------
%----------------------------------------
% work_dir = STRINGS % [WORK_DIR]
%----------------------------------------
%----------------------------------------
% mfile = STRINGS % [MFILE]
%----------------------------------------
%
%=========================================================================
% [MODEL] -> [CONDITIONS] [STOCHASTICS] [REGRESSORS] [PARAMETRICS]
%=========================================================================
%----------------------------------------
% model : STRUCT % [MODEL]
%----------------------------------------
%................[UNIQUE]...................
% 'types'      
%                     1 <-> 'specify a model', 
%                     2 <-> 'review a specified model',
%                     3 <-> 'estimate a specified model', 
%                     4 <-> 'specify and estimate a model'
% 'global_effects',  'Scaling|None', 
% 'burst_mode',      'y/n',[1 0], 
% 'HF_fil',          'none|specify',  
% 'LF_fil',          'none|Gaussian|hrf', 
% 'LF_cut',          VALUE, 
%                    'Gaussian FWHM (secs)'
% 'int_corr',        {'none','AR(1)'},  
% 'trial_fcon',      'yes|no', [1,0], 
% 'now_later',       'now|later', [1,0], 
% 'stop_writing',     0 if previous results should be overwritten, 1 otherwise
% 'RT',              VALUE, 
% 'replicated',     'yes|no',[1 0], 
% 'same_time_param','yes|no',[1 0],
% 'nsess',           VALUE
%                    number of sessions
%................[MULTIPLE]................
% 'HF_cut'           INTEGER_ARRAY
%                    'session cutoff period (secs)'
% 'files',           {STRING_ARRAYS}, 
% 'nscans',          INTEGER_ARRAY,
% 'conditions_nb',   INTEGER_ARRAY,
% 'regressors_nb',   INTEGER_ARRAY,
% 'parametrics_type', STRINGS, {'none','time','other'},
% 'stochastics_flag', INTEGER_ARRAY, 'yes|no',[1 0],
% 'conditions',      INDICES, 
% 'stochastics',     INDICES, 
% 'regressors',      INDICES, 
% 'parametrics',     INDICES 
%
%----------------------------------------
% stochastics : STRUCT % [STOCHASTICS]
%----------------------------------------
%................[UNIQUE]...................
% 'null_event',  'y/n',[1 0]
% 'soa',          VALUE
%                 SOA (scans)
% 'relative_frequency', VALUE
%                'relative frequency [trial 1,..'
% 'stationary_or_modulated', 'stationary|modulated',[1 0]
%
%----------------------------------------
% regressors : STRUCT % [REGRESSORS]
%----------------------------------------
%................[MULTIPLE]................
% 'names',       STRINGS
% 'values',      ARRAY (number of scans x number of regressors)
%
%----------------------------------------
% parametrics : STRUCT % [PARAMETRICS]
%----------------------------------------
%................[UNIQUE]...................
% 'name',       STRING 
% 'exp_type',   {'linear','exponen','polynom'} 
% 'time_cst',   VALUE
%               'time constant {secs}'
% 'decay_cst',  VALUE
% 'order',      VALUE 
%................[MULTIPLE]................
% 'trials',     INTEGER_ARRAY
% 'parameters', VALUE_ARRAYS 
%
%=======================================================================
% [CONDITIONS] -> [BF_EV] [BF_EP]
%=======================================================================
%----------------------------------------
% conditions : STRUCT % [CONDITIONS]
%----------------------------------------
%................[UNIQUE]...................
% 'volterra',    'y/n',[1 0]
% 'variable_dur',    'yes|no',[1 0],
%................[MULTIPLE]................
% 'types',       STRINGS, {'events','epochs'},
% 'names',       STRINGS
% 'onsets',      VALUE_ARRAYS
% 'durations',   VALUE_ARRAYS   
% 'bf_ev',       INDICES
% 'bf_ep',       INDICES
%
%
%----------------------------------------
% bf_ev : STRUCT % [BF_EV]
%----------------------------------------
%................[UNIQUE]...................
% 'ev_type'
%   1 <->  'hrf (alone)',
%   2 <->  'hrf (with time derivative)',
%   3 <->  'hrf (with time and dispersion derivatives)',
%   4 <->  'basis functions (Fourier set)',
%   5 <->  'basis functions (Windowed Fourier set)',
%   6 <->  'basis functions (Gamma functions)',
%   7 <->  'basis functions (Gamma functions with derivatives)'};
% 'win_len',VALUE|[] 
%          'window length {secs}'
% 'order',  VALUE|[] 
%   
%----------------------------------------
% bf_ep : STRUCT % [BF_EP]
%----------------------------------------
%................[UNIQUE]...................
% 'ep_type'
%   1 <->   'basis functions  (Discrete Cosine Set)',
%   2 <->   'basis functions  (Mean & exponential decay)',
%   3 <->   'fixed response   (Half-sine)',
%   4 <->   'fixed response   (Box-car)'};
% 'fct_nb',  VALUE, 
%            'number of basis functions'
% 'conv',   'yes|no', [1 0] 
% 'deriv',  'yes|no', [1 0] 
% 'length',  VALUE
%            'epoch length {scans} for condition' 
%
%=========================================================================
% [CONTRASTS]
%=========================================================================
% ATTENTION : the contrasts size must be of the number of parameter
% of the design matrix, INCLUDING block (session) effects.
% Contrasts can be taken from old xCon.mat file in the xCon(i).c'
%
%----------------------------------------
% contrasts : STRUCT % [CONTRASTS]
%----------------------------------------
%................[MULTIPLE]................
%  'names',    STRINGS, 
%  'types',    {'F'|'T'}, 
%  'values',   VALUE_ARRAYS, 
%
%=========================================================================
% [HEADERS]
%=========================================================================
%----------------------------------------
% headers : STRUCT % [HEADERS]
%----------------------------------------
%................[UNIQUE]...................
% 'DIM',        [Dx Dy Dz], 
% 'VOX',        [Vx Vy Vz],
% 'SCALE',      VALUE, ...
% 'TYPE',       see spm_type, 
%               takes spm or matlab representation
% 'OFFSET',     INTEGER, 
% 'ORIGIN',     [Ox Oy Oz], 
%               Give the origin in Voxel
% 'DESCRIP',    STRING ...
% 'files',      STRING_ARRAY, 
% 'do_mat',     'y/n',[1 0] ...
% 'origoff',    [ofx ofy ofz]...
%
%=========================================================================
% [MEANS]
%=========================================================================
% means : STRUCT % [MEANS] 
%-------------------------------------------------------------------------
%................[MULTIPLE]................
% 'files',  {STRING_ARRAYS}, 
% 'unique', INTEGER_ARRAY
%     0 (files can be duplicate) or 1 (a "unique" is performed) 
%
%
%=========================================================================
% [DEFAULTS_EDIT] -> [MISC] [PRINTIMG] [HDR] [REALIGNCOREG] 
%                       [NORMALISATION] [STATISTICS] 
%=========================================================================
%
%----------------------------------------
% defaults_edit : STRUCT % [DEFAULTS_EDIT]
%----------------------------------------
%................[MULTIPLE]................
% 'type_area',  INDICES
%                1 <-> 'Printing Options'
%                2 <-> 'Miscellaneous Defaults'
%                3 <-> 'Header Defaults - ',MODALITY
%                4 <-> 'Realignment & Coregistration'
%                5 <-> 'Spatial Normalisation'
%                6 <-> 'Statistics - ',MODALITY
%                7 <-> 'Reset All'
% 'index',      INTEGER_ARRAY
%
%----------------------------------------
% Printing  : STRUCT % [PRINTING]
%----------------------------------------
%................[UNIQUE]...................
%  'printing_mode'
%      1 <-> 'Postscript to File'
%      2 <-> 'Postscript to Printer'
%      3 <-> 'Other Format to File'
%      4 <-> 'Custom'
%  'postscript_filename', STRING
%  'postscript_type'
%      1 <-> 'PostScript for black and white printers'
%      2 <-> 'PostScript for colour printers'
%      3 <-> 'Level 2 PostScript for black and white printers'
%      4 <-> 'Level 2 PostScript for colour printers'
%      5 <-> 'Encapsulated PostScript (EPSF)'
%      6 <-> 'Encapsulated Colour PostScript (EPSF)'
%      7 <-> 'Encapsulated Level 2 PostScript (EPSF)'
%      8 <-> 'Encapsulated Level 2 Color PostScript (EPSF)'
%      9 <-> 'Encapsulated        with 1-bit preview (EPSI)'
%      10 <-> 'Encapsulated Colour with 1-bit preview (EPSI)'
%      11 <-> 'Encapsulated Level 2   w 1-bit preview (EPSI)'
%      12 <-> 'Encapsulated Level 2 Colour  w preview (EPSI)'
%  'default_printer', 'yes|no', [1 0]
%  'printer_name', STRING
%  'post_type'
%      -dps <-> B & W
%      -dpsc <-> colour
%  'graphics_filename', STRING
%  'graph_type'
%               1 <-> 'HPGL compatible with Hewlett-Packard 7475A plotter'
%               2 <-> 'Adobe Illustrator 88 compatible illustration file'
%               3 <-> 'M-file (and Mat-file, if necessary)'
%               4 <-> 'Baseline JPEG image'
%               5 <-> 'TIFF with packbits compression'
%               6 <-> 'Color image format']
%  'print_string', STRING
%
%----------------------------------------
% Misc  : STRUCT % [MISC]
%----------------------------------------
%................[UNIQUE]...................
%  'log_to_file', 'yes|no', [1 0]
%  'log_file_name', STRING 
%  'cmdline', 'yes|no', [1 0]
%  'grid', VALUE
%
%----------------------------------------
% Hdr  : STRUCT % [HDR]
%----------------------------------------
%................[UNIQUE]...................
%  'image_size_voxels', STRING
%  'voxel_size_mm', STRING
%  'scale', VALUE
%  'data_type'
%     2  <-> 'Unsigned Char     (8  bit)'
%     4  <-> 'Signed Short      (16 bit)'
%     8  <-> 'Signed Integer (32 bit)' 
%     16 <-> 'Floating Point'
%     32 <-> 'Double Precision'
%  'offset', VALUE
%  'origin_voxels', STRING
%  'description', STRING
%
%----------------------------------------
%  Statistics  : STRUCT % [STATISTICS]
%----------------------------------------
%................[UNIQUE]...................
%  'F_threshold', VALUE
%  'fMRI_T',      VALUE
%  'fMRI_T0',     VALUE
%
%----------------------------------------
% RealignCoreg  : STRUCT % [REALIGNCOREG]
%----------------------------------------
%................[UNIQUE]...................
%  'separate_combine'
%               -1 <-> 'Allow separate coregistration and reslicing'
%               1  <-> 'Combine coregistration and reslicing'
%  'create'
%     1  <-> 'All Images + Mean Image'
%     -1 <-> 'Full options'
%  'adjust'
%     1  <-> 'Always adjust'
%     0  <-> 'Never adjust'
%     -1 <-> 'Optional adjust'
%  'mask'
%     1  <-> 'Always mask'
%     -1 <-> 'Optional mask'
%  'reg_quality'
%     [1.00 0.90 0.75 0.50 0.25 0.10 0.05 0.01 0.005 0.001]
%     <-> ['Quality 1.00  (slowest/most accurate) |Quality 0.90|' ...
%          'Quality 0.75|Quality 0.50|Quality 0.25|Quality 0.10|' ...
%          'Quality 0.05|Quality 0.01|' ...
%          'Quality 0.005|Quality 0.001 (fastest/poorest)']
%
%----------------------------------------
% Normalisation  : STRUCT % [NORMALISATION]
%----------------------------------------
%................[UNIQUE]...................
%  'defaults'
%     1 <-> 'Defaults for Parameter Estimation'
%     0 <-> 'Defaults for Writing Normalized'
%----------------------------------------
% IF DEFAULTS == 1
%................[UNIQUE]...................
%  'estimates'
%     0 <-> 'Neurological Convention (R is R)'
%     1 <-> 'Radiological Convention (L is R)'
%     2 <-> 'Custom Affine Starting Estimates'
%  'custom_estimates', VALUE_ARRAY (1x12)
%  'custom_norm', 
%     -1 <-> 'Allow customised'
%     1  <-> 'Disallow Customised'
%  'nonlin_func_nb'
%     0:14  <-> 'Custom|none|2x2x2|2x3x2|3x3x3|3x4x3|4x4x4|4x5x4|...
%                5x5x5|5x6x5|6x6x6|6x7x6|7x7x7|7x8x7|8x8x8'
%  'func_nb', INTEGER
%  'nonlin_ite_nb', INTEGER ([1 3 5 8 12 16]),
%  'nonlin_regular'
%      [1 0.1 0.01 0.001 0.0001] <-> 'Extremely Heavy regularization|...
%      Heavy regularization|Medium regularization|Light regularization|...
%      Very Light regularization'
%  'mask_brain', 'yes|no', [1 0],
%  'mask_object_brain', 'yes|no', [1 0],
%----------------------------------------
% IF DEFAULTS == 0
%................[UNIQUE]...................
%  'bounding_box'
%      -1 <-> 'Runtime option'
%      0  <-> 'Customise'
%      1  <-> '-78:78 -112:76  -50:85  (Default)'
%      2  <-> '-64:64 -104:68  -28:72  (SPM95)'
%      3  <-> '-90:91 -126:91  -72:109 (Template)'
%      4  <-> '-95:95 -112:76  -50:95 '
%  'direction1', VALUE_ARRAY ([xmin;xmax])
%  'direction2', VALUE_ARRAY ([ymin;ymax])
%  'direction3', VALUE_ARRAY ([zmin;zmax])
%  'voxel_sizes'
%      -1:7 <-> 'Runtime option|Customise|1 1 1|1.5 1.5 1.5|2 2 2|...
%                3 3 3|4 4 4|1 1 2|2 2 4'
%  'voxel_sizes_custom', VALUE_ARRAY (1*3)
%
%-------------------------------------------------------------------------
%
%=========================================================================
% [NORMALIZE]  
%=========================================================================
%
%----------------------------------------
% normalize : STRUCT % [NORMALIZE]
%----------------------------------------
%................[UNIQUE]...................
%  'option'
%                1 <-> 'Determine Parameters Only'
%                2 <-> 'Write Normalised Only'
%                3 <-> 'Determine Parameters & Write Normalised'
%  'nbsubjects', INTEGER
%  'object_masking', 'yes|no', [1 0]
%  'template', STRING
%  'type'
%      0 <-> 'Default Normalisation' 
%      1 <-> 'Custom Normalisation'
%  'nonlin_func_nb'
%      0:14  <-> 'Custom|none|2x2x2|2x3x2|3x3x3|3x4x3|4x4x4|4x5x4|...
%                5x5x5|5x6x5|6x6x6|6x7x6|7x7x7|7x8x7|8x8x8'
%  'func_nb', INTEGER
%  'nonlin_ite_nb', INTEGER ([1 3 5 8 12 16])
%  'nonlin_regular'
%      [1 0.1 0.01 0.001 0.0001] <-> 'Extremely Heavy regularization|...
%      Heavy regularization|Medium regularization|Light regularization|...
%      Very Light regularization'
%  'mask_brain', 'yes|no', [1 0],
%  'interp'
%      0  <-> 'Nearest Neighbour'
%      1  <-> 'Bilinear Interpolation'
%      -9 <-> 'Sinc Interpolation (9x9x9)'
%  'bounding_box'
%      0 <-> 'Customise'
%      1 <-> '-78:78 -112:76  -50:85  (Default)'
%      2 <-> '-64:64 -104:68  -28:72  (SPM95)'
%      3 <-> '-90:91 -126:91  -72:109 (Template)'
%      4 <-> '-95:95 -112:76  -50:95 '
%  'direction1', VALUE_ARRAY ([xmin;xmax])
%  'direction2', VALUE_ARRAY ([ymin;ymax])
%  'direction3', VALUE_ARRAY ([zmin;zmax])
%  'voxel_sizes'
%      0:7 <-> 'Customise|1 1 1|1.5 1.5 1.5|2 2 2|3 3 3|...
%                4 4 4|1 1 2|2 2 4'
%  'voxel_sizes_custom', VALUE_ARRAY (1*3)
%
%................[MULTIPLE]................
%  'image'      STRING_ARRAY (1*nbsubjects)
%                                       to determine parameters from,
%  'objmask'    STRING_ARRAY (1*nbsubjects)
%                                       object masking image, '' for none,
%  'matname'    STRING_ARRAY (1*nbsubjects)
%                                       normalisation parameter set,
%  'images'     {STRING_ARRAYS} (1*nbsubjects)
%                                       images to write normalised, 

%=========================================================================
% [REALIGN]  -> [SESSIONS] 
%=========================================================================
%
%----------------------------------------
% realign : STRUCT % [REALIGN]
%----------------------------------------
%................[UNIQUE]...................
%  'subject_nb',   INTEGER
%  'num_sessions', INTEGER
%  'option'
%      1 <-> 'Coregister only'
%      2 <-> 'Reslice Only'
%      3 <-> 'Coregister & Reslice' 
%  'modality'
%      1 <-> 'EPI MR images'
%      2 <-> 'PET images'
%      3 <-> 'T1 MR images'
%      4 <-> 'T2 MR images'
%      5 <-> 'Transm images'
%  'reslice_method'
%      1 <-> 'Trilinear Interpolation'
%      2 <-> 'Sinc Interpolation'
%      3 <-> 'Fourier space Interpolation'
%  'create'
%      1 <-> 'All Images (1..n)'
%      2 <-> 'Images 2..n'
%      3 <-> 'All Images + Mean Image'
%      4 <-> 'Mean Image Only'
%  'mask', 'yes|no', [1 0]
%  'adjust_sampling_errors', 'yes|no', [1 0]
%
%................[MULTIPLE]................
%  'sessions',    INDICES
%
%----------------------------------------
% sessions : STRUCT % [SESSIONS]
%----------------------------------------
%   'images', {STRING_ARRAYS},
%
%
%
%_______________________________________________________________________
