
% Image Format
%___________________________________________________________________________
%
% SPM has been written to deal with two or three dimensional data of
% any size (either image dimensions or voxel size). The data however
% should be organized with a separate file for each scan.
%
% SPM uses the simple header and flat binary image file format of
% ANALYZE-7 (Mayo Clinic, Rochester, USA. - http://www.mayo.edu/bir/),
% with slight customisations to the header.
%
%                           ----------------
% The image file.
%
% *.img: An uninterrupted array of (unsigned integer, signed short,
% signed integer, float or double) voxel values.  Each *.img usually
% has an associated header file that contains information about the
% image process in question
%
% The original images which SPM uses can be in any orientation.
% However, after spatial normalisation, the images must be in the
% following orientation:
%	X increases from Left to Right
%	Y increases from Posterior to Anterior
%	Z increases from Inferior to Superior
% This is a right handed coordinate system, and is consistent with the
% Talairach atlas.
%
% In order to sucessfully spatially normalise the images, SPM must be
% able to determine the initial orientation of the images.  The global
% variable "sptl_Ornt" contains this orientation.  This is initially
% set from the file "spm_defaults.m". This can however be changed from
% within SPM (for the duration of the SPM session) using the `Defaults'
% button.  For instance, left-right (radiological v neurological)
% orientations can easily be specified.
%
%
%                           ----------------
% The header file.
%
% *.hdr: The format of the 348 byte header file is that adopted by
% ANALYZE (http://www.mayo.edu/bir/analyze/AnalyzeFileInfo.html).  The
% fields that are necessary in the context of SPM include:
%
% Field                                    [SPM default global variable]
%
% image size {in voxels for x, y and z}                            [DIM]
% voxel size {in mm for x, y and z}                                [VOX]
% data type {see spm_type.m}                                      [TYPE]
% a scaling coefficient {applied during memory mapping}          [SCALE]
% offset of voxel values in *.img {in bytes}                    [OFFSET]
% the origin {(x,y,z) in voxels} {e.g. the anterior commissure} [ORIGIN]
% description {a short string}                                 [DESCRIP]
%
% If *.hdr does not exist then the default values are assumed.  Default
% values can be changed by selecting 'defaults'.  *.hdr can be created
% (and can be edited) using the 'Display' facility.
%
% It is important that these header files are correct.  The most common
% problems with using SPM usually reduce to incomplete or incorrect
% header files.
%
%                           ----------------
% The `.mat' file.
%
% This simply contains a 4x4 affine transformation matrix in a variable
% `M'.  These files are normally generated by the `realignment' and
% `coregistration' modules.  What these matrixes contain is a mapping
% from the voxel coordinates (x0,y0,z0) (where the first voxel is at
% coordinate (1,1,1)), to coordinates in millimeters (x1,y1,z1).  By
% default, the the new coordinate system is derived from the `origin'
% and `vox' fields of the image header.
%  
% x1 = M(1,1)*x0 + M(1,2)*y0 + M(1,3)*z0 + M(1,4)
% y1 = M(2,1)*x0 + M(2,2)*y0 + M(2,3)*z0 + M(2,4)
% z1 = M(3,1)*x0 + M(3,2)*y0 + M(3,3)*z0 + M(3,4)
%
% Assuming that image1 has a transformation matrix M1, and image2 has a
% transformation matrix M2, the mapping from image1 to image2 is: M2\M1
% (ie. from the coordinate system of image1 into millimeters, followed
% by a mapping from millimeters into the space of image2).
%
% These `.mat' files allow several realignment or coregistration steps
% to be combined into a single operation (without the necessity of
% resampling the images several times).  The `.mat' files are also used
% by the spatial normalisation module.
%
%-----------------------------------------------------------------------
% See also:
%        spm_hread.m
%        spm_hwrite.m
%        spm_type.m
%        spm_defaults.m
%        spm_get_space.m
%        spm_create_image.m
%__________________________________________________________________________
% @(#)spm_format.man	2.1 John Ashburner 99/05/16
